/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DataPackRegistryEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static RegistryAccess getRegistryAccess(Level level) {
        return level.m_9598_();
    }

    public static DeferredRegister<PlacementModifierType<?>> createPlacementRegistry(String modid) {
        return DeferredRegister.create((ResourceKey)Registries.f_256843_, (String)modid);
    }

    public static <T> Supplier<IForgeRegistry<T>> makeCustomRegistry(DeferredRegister<T> defferedRegistry, Codec<T> codec) {
        return null;
    }

    public static void onDataPackRegistry(IEventBus bus, Consumer<IDPRegister> consumer) {
        bus.addListener(event -> consumer.accept(new IDPRegister((DataPackRegistryEvent.NewRegistry)event){
            final /* synthetic */ DataPackRegistryEvent.NewRegistry val$event;
            {
                this.val$event = newRegistry;
            }

            @Override
            public <T> void register(ResourceKey<Registry<T>> key, Codec<T> codec) {
                this.val$event.dataPackRegistry(key, codec, codec);
            }
        }));
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return ForgeRegistries.ENTITY_TYPES.getKey(entityType);
    }

    public static ResourceLocation getId(ItemStack item) {
        return ForgeRegistries.ITEMS.getKey((Object)item.m_41720_());
    }

    public static ResourceLocation getId(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }

    public static ResourceLocation getId(BlockState block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block.m_60734_());
    }

    public static ResourceLocation getId(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block);
    }

    public static ResourceLocation getId(FluidStack fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid.getFluid());
    }

    public static ResourceLocation getId(FluidState fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid.m_76152_());
    }

    public static ResourceLocation getId(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public static ResourceLocation getId(CommonLevelAccessor level, Biome biome) {
        return level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
    }

    public static ResourceLocation getId(CommonLevelAccessor level, Structure feature) {
        return level.m_9598_().m_175515_(Registries.f_256944_).m_7981_((Object)feature);
    }

    public static String getModid(ItemStack stack) {
        if (!stack.m_41619_()) {
            return Tools.getId(stack).m_135827_();
        }
        return "";
    }

    public static String getModName(Fluid entry) {
        ResourceLocation registryName = ForgeRegistries.FLUIDS.getKey((Object)entry);
        String modId = registryName == null ? "minecraft" : registryName.m_135827_();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static String getModName(Block entry) {
        ResourceLocation registryName = ForgeRegistries.BLOCKS.getKey((Object)entry);
        String modId = registryName == null ? "minecraft" : registryName.m_135827_();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer, String error) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static <INPUT extends BASE, BASE, RET> RET safeMap(BASE o, Function<INPUT, RET> consumer, String error) {
        try {
            return consumer.apply(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static String getReadableName(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return Tools.getReadableName(state.m_60734_().m_7397_((BlockGetter)world, pos, state));
    }

    public static String getReadableName(ItemStack stack) {
        return stack.m_41786_().getString();
    }

    @Nullable
    public static BlockState placeStackAt(Player player, ItemStack blockStack, Level world, BlockPos pos, @Nullable BlockState origState) {
        BlockHitResult trace = new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockPlaceContext context = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, trace));
        Item item = blockStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            if (origState == null && (origState = itemBlock.m_40614_().m_5573_(context)) == null) {
                return null;
            }
            if (itemBlock.m_40576_(context).m_19077_()) {
                blockStack.m_41774_(1);
            }
            return origState;
        }
        player.m_21008_(InteractionHand.MAIN_HAND, blockStack);
        player.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
        blockStack.m_41720_().m_6225_((UseOnContext)context);
        return world.m_8055_(pos);
    }

    public static interface IDPRegister {
        public <T> void register(ResourceKey<Registry<T>> var1, Codec<T> var2);
    }
}

