/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.net;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.blocks.BlockMultipartContainer;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;

@MainThreaded
public class PacketSendRunningEffect
implements IPacket {
    protected BlockPos pos;
    protected int entityId;
    protected AABB entityAABB;
    protected Vec3 particlePos;

    public PacketSendRunningEffect(BlockPos pos, Entity entity) {
        this.pos = pos;
        this.entityId = entity.m_19879_();
        this.entityAABB = entity.m_20191_();
        RandomSource random = RandomSource.m_216327_();
        BlockPos bpos = entity.m_20183_();
        double x = entity.m_20185_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
        double y = entity.m_20186_() + 0.1;
        double z = entity.m_20189_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
        if (bpos.m_123341_() != pos.m_123341_()) {
            x = Mth.m_14008_((double)x, (double)pos.m_123341_(), (double)((double)pos.m_123341_() + 1.0));
        }
        if (bpos.m_123343_() != pos.m_123343_()) {
            z = Mth.m_14008_((double)z, (double)pos.m_123343_(), (double)((double)pos.m_123343_() + 1.0));
        }
        this.particlePos = new Vec3(x, y, z);
    }

    public PacketSendRunningEffect() {
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.entityId);
        buf.writeDouble(this.entityAABB.f_82288_);
        buf.writeDouble(this.entityAABB.f_82289_);
        buf.writeDouble(this.entityAABB.f_82290_);
        buf.writeDouble(this.entityAABB.f_82291_);
        buf.writeDouble(this.entityAABB.f_82292_);
        buf.writeDouble(this.entityAABB.f_82293_);
        buf.writeDouble(this.particlePos.f_82479_);
        buf.writeDouble(this.particlePos.f_82480_);
        buf.writeDouble(this.particlePos.f_82481_);
    }

    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.entityId = buf.readInt();
        double minX = buf.readDouble();
        double minY = buf.readDouble();
        double minZ = buf.readDouble();
        double maxX = buf.readDouble();
        double maxY = buf.readDouble();
        double maxZ = buf.readDouble();
        this.entityAABB = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        this.particlePos = new Vec3(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Entity entity = level.m_6815_(this.entityId);
            if (entity == null) {
                return;
            }
            PartContainer ctr = BlockMultipartContainer.pc((BlockGetter)level, this.pos);
            if (ctr == null) {
                return;
            }
            Vec3 vec3 = entity.m_20184_();
            Vec3 motion = new Vec3(vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
            for (PartEntity part : ctr.parts()) {
                VoxelShape shape = Shapes.m_83113_((VoxelShape)part.getShape().m_83216_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)this.entityAABB.m_82400_(0.1)), (BooleanOp)BooleanOp.f_82689_);
                if (shape.m_83281_()) continue;
                IClientPartDefinitionExtensions.of(part).addRunningEffects(part, shape, entity, this.entityAABB, this.particlePos, motion);
            }
        }
    }
}

