/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.impl.parts.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.init.PartPlacementsHM;

public class PartEntityTorch
extends PartEntity {
    public final ParticleOptions flameParticle = ParticleTypes.f_123744_;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private static VoxelShape AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public PartEntityTorch(PartDefinition definition, PartContainer container, PartPlacement placement) {
        super(definition, container, placement);
    }

    @Override
    public VoxelShape updateCollisionShape() {
        return Shapes.m_83040_();
    }

    @Override
    public List<ItemStack> getDrops(@Nullable ServerPlayer harvester, LootParams.Builder drops) {
        return Blocks.f_50081_.m_49635_(Blocks.f_50081_.m_49966_(), drops);
    }

    @Override
    protected VoxelShape updateShape() {
        if (this.placement == PartPlacementsHM.DOWN) {
            return AABB;
        }
        Direction direction = this.placement.getDirection();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return super.updateShape();
        }
        return AABBS.get(direction.m_122424_());
    }

    @Override
    public VoxelShape getPartOccupiedShape() {
        return this.getShape();
    }

    @Override
    public Optional<Tuple2<BlockState, Function<BlockPos, BlockEntity>>> disassemblePart() {
        return Optional.of(Tuples.immutable((Object)this.getRenderState(), null));
    }

    @Override
    public void animateTick(RandomSource random) {
        if (random.m_188499_()) {
            return;
        }
        Level level = this.container.level();
        BlockPos pos = this.container.pos();
        if (this.placement == PartPlacementsHM.DOWN) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.7;
            double d2 = (double)pos.m_123343_() + 0.5;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            level.m_7106_(this.flameParticle, d0, d1, d2, 0.0, 0.0, 0.0);
        } else {
            Direction direction = this.placement.getDirection();
            if (direction == null) {
                return;
            }
            direction = direction.m_122424_();
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.7;
            double d2 = (double)pos.m_123343_() + 0.5;
            Direction direction1 = direction.m_122424_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
            level.m_7106_(this.flameParticle, d0 + 0.27 * (double)direction1.m_122429_(), d1 + 0.22, d2 + 0.27 * (double)direction1.m_122431_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void neighborChanged(@Nullable Direction from, BlockPos neigborPos, BlockState neigborState, boolean waterlogged) {
        Direction towards = this.placement.getDirection();
        if (towards == null) {
            return;
        }
        if (PartPlacementsHM.SIDED_PLACEMENT.apply(towards) != this.placement) {
            return;
        }
        BlockPos pos = this.container.pos().m_121945_(towards);
        if (waterlogged || !this.container.level().m_8055_(pos).m_60783_((BlockGetter)this.container.level(), pos, towards.m_122424_())) {
            this.container.queuePartRemoval(this.placement, true, true, true);
        }
    }

    @Override
    public int getLightEmission() {
        return 14;
    }

    @Override
    @Nullable
    public BlockState getRenderState() {
        Direction dir = this.placement.getDirection();
        if (dir == null || dir == Direction.DOWN) {
            return Blocks.f_50081_.m_49966_();
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)Blocks.f_50082_.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)this.placement.getDirection().m_122424_());
    }

    @Override
    public boolean isViewBlocking() {
        return false;
    }
}

