/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.impl.parts.entities;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.init.PartPlacementsHM;

public class PartEntityLadder
extends PartEntity {
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);

    public PartEntityLadder(PartDefinition definition, PartContainer container, PartPlacement placement) {
        super(definition, container, placement);
    }

    @Override
    public List<ItemStack> getDrops(@Nullable ServerPlayer harvester, LootParams.Builder drops) {
        return Blocks.f_50155_.m_49635_(Blocks.f_50155_.m_49966_(), drops);
    }

    @Override
    protected VoxelShape updateShape() {
        Direction direction = this.placement.getDirection();
        if (direction == null) {
            return EAST_AABB;
        }
        return switch (direction.m_122424_()) {
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            default -> EAST_AABB;
        };
    }

    @Override
    public VoxelShape getPartOccupiedShape() {
        return this.getShape();
    }

    @Override
    public Optional<Tuple2<BlockState, Function<BlockPos, BlockEntity>>> disassemblePart() {
        return Optional.of(Tuples.immutable((Object)((BlockState)this.getRenderState().m_61124_((Property)LadderBlock.f_54338_, (Comparable)Boolean.valueOf(this.container.waterlogged))), null));
    }

    @Override
    public void neighborChanged(@Nullable Direction from, BlockPos neigborPos, BlockState neigborState, boolean waterlogged) {
        Direction towards = this.placement.getDirection();
        if (towards == null) {
            return;
        }
        if (PartPlacementsHM.SIDED_PLACEMENT.apply(towards) != this.placement) {
            return;
        }
        BlockPos pos = this.container.pos().m_121945_(towards);
        BlockState blockstate = this.container.level().m_8055_(pos);
        if (!blockstate.m_60783_((BlockGetter)this.container.level(), pos, towards.m_122424_())) {
            this.container.queuePartRemoval(this.placement, true, true, true);
        }
    }

    @Override
    @Nullable
    public BlockState getRenderState() {
        Direction dir = this.placement.getDirection();
        if (dir == null || dir.m_122434_() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)this.placement.getDirection().m_122424_());
    }

    @Override
    public boolean isLadder(LivingEntity entity) {
        return entity == null || this.getCollisionShape().m_83215_().m_82338_(this.container.pos()).m_82400_(0.15).m_82381_(entity.m_20191_());
    }

    @Override
    public boolean makesOpenTrapdoorAboveClimbable(BlockState trapdoorState) {
        return this.placement.getDirection() == ((Direction)trapdoorState.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122424_();
    }

    @Override
    public boolean isViewBlocking() {
        return false;
    }
}

