/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.impl.parts;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.placement.IConfiguredPartPlacer;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PlacedPartConfiguration;
import org.zeith.multipart.impl.parts.entities.PartEntityChain;
import org.zeith.multipart.init.PartDefinitionsHM;
import org.zeith.multipart.init.PartPlacementsHM;

public class PartDefChain
extends PartDefinition {
    public PartDefChain() {
        this.model.addParticleIcon(new ResourceLocation("block/chain"));
        this.soundType = SoundType.f_56728_;
        this.destroySpeed = 5.0f;
        this.cloneItem = () -> ((Item)Items.f_42026_).m_7968_();
    }

    public Optional<PlacedPartConfiguration> getPlacement(Level level, BlockPos pos, Player player, ItemStack stack, BlockHitResult hit) {
        Direction towards = hit.m_82434_().m_122424_();
        return Optional.of(new PlacedPartConfiguration(this, new ChainPartPlacer(towards.m_122434_()), PartPlacementsHM.CENTER));
    }

    @Override
    public Optional<PlacedPartConfiguration> convertBlockToPart(Level level, BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_50184_)) {
            return Optional.of(new PlacedPartConfiguration(this, new ChainPartPlacer((Direction.Axis)state.m_61143_((Property)ChainBlock.f_55923_)), PartPlacementsHM.CENTER));
        }
        return Optional.empty();
    }

    @Override
    public boolean canPlaceAt(PartContainer container, @Nullable IConfiguredPartPlacer placer, PartPlacement placement) {
        return placement == PartPlacementsHM.CENTER;
    }

    @Override
    public PartEntity createEntity(PartContainer container, PartPlacement placement) {
        return new PartEntityChain(this, container, placement);
    }

    public record ChainPartPlacer(Direction.Axis placeAxis) implements IConfiguredPartPlacer
    {
        @Override
        public PartEntity create(PartContainer container, PartPlacement placement) {
            PartEntityChain def = new PartEntityChain(PartDefinitionsHM.CHAIN_PART, container, placement);
            def.axis = this.placeAxis;
            return def;
        }
    }
}

