/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.client.model.IBakedModel;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;
import org.zeith.multipart.client.model.BakedPartDefinitionModel;
import org.zeith.multipart.client.model.IBakedMultipartModel;
import org.zeith.multipart.client.model.IPartModelBaker;
import org.zeith.multipart.init.PartRegistries;

@LoadUnbakedGeometry(path="multipart")
public class DynamicMultipartModel
implements IUnbakedGeometry<DynamicMultipartModel> {
    public DynamicMultipartModel(JsonObject json, JsonDeserializationContext context) {
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        HashMap<PartDefinition, BakedPartDefinitionModel> bakedParts = new HashMap<PartDefinition, BakedPartDefinitionModel>();
        for (PartDefinition def : PartRegistries.partDefinitions()) {
            BakedPartDefinitionModel baked;
            IPartModelBaker partBaker = IPartModelBaker.of(def.getModel());
            if (partBaker == null || (baked = partBaker.bake(context, baker, spriteGetter, modelState)) == null) continue;
            bakedParts.put(def, baked);
        }
        TextureAtlasSprite defaultParticle = spriteGetter.apply(new Material(InventoryMenu.f_39692_, new ResourceLocation("block/stone")));
        return new Baked(bakedParts, defaultParticle);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return List.of();
    }

    public static UnaryOperator<BakedQuad> replaceTintIndex(int src, int dst) {
        return quad -> {
            if (quad.m_111305_() == src) {
                return new BakedQuad(quad.m_111303_(), dst, quad.m_111306_(), quad.m_173410_(), quad.m_111307_(), quad.hasAmbientOcclusion());
            }
            return quad;
        };
    }

    private record Baked(Map<PartDefinition, BakedPartDefinitionModel> bakedParts, TextureAtlasSprite defaultParticle) implements IBakedModel,
    IBakedMultipartModel
    {
        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            PartContainer ctr = (PartContainer)data.get(PartContainer.CONTAINER_PROP);
            Long hash = (Long)data.get(PartContainer.PART_HASH);
            if (ctr == null || hash == null || hash == 0L) {
                return List.of();
            }
            ctr.recalcTintLayers(hash);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            while (true) {
                try {
                    quads.clear();
                    for (PartEntity part : ctr.parts()) {
                        BakedPartDefinitionModel baked;
                        int[] indices = part.getTintIndices();
                        Consumer<BakedQuad> quadConsumer = quad -> {
                            int idx = quad.m_111305_();
                            if (idx >= 0 && idx < indices.length) {
                                quad = new BakedQuad(quad.m_111303_(), indices[idx], quad.m_111306_(), quad.m_173410_(), quad.m_111307_(), quad.hasAmbientOcclusion());
                            }
                            quads.add((BakedQuad)quad);
                        };
                        if (IClientPartDefinitionExtensions.of(part).getQuads(part, side, rand, data, renderType, quadConsumer) || (baked = this.getBakedPart(part)) == null) continue;
                        baked.getQuads(part, side, rand, data, renderType, quadConsumer);
                    }
                }
                catch (ConcurrentModificationException cme) {
                    continue;
                }
                break;
            }
            return quads;
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return ChunkRenderTypeSet.all();
        }

        public boolean m_7541_() {
            return true;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return true;
        }

        public TextureAtlasSprite m_6160_() {
            return this.defaultParticle;
        }

        @Override
        public BakedPartDefinitionModel getBakedPart(PartEntity entity) {
            return this.bakedParts.get(entity.definition());
        }
    }
}

