/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.client;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.zeith.hammerlib.util.AABBUtils;
import org.zeith.hammerlib.util.colors.ColorHelper;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.api.WorldPartComponents;
import org.zeith.multipart.client.IClientPartDefinitionExtensions;
import org.zeith.multipart.client.model.BakedPartDefinitionModel;
import org.zeith.multipart.client.model.IBakedMultipartModel;
import org.zeith.multipart.mixins.client.TextureSheetParticleAccessor;

public class MultipartEffects {
    static final Random random = new Random();

    public static void spawnBreakFX(BlockPos pos, VoxelShape voxelshape, Supplier<TintedSprite> selector) {
        BlockState state = WorldPartComponents.BLOCK.m_49966_();
        Minecraft mc = Minecraft.m_91087_();
        double d0 = 0.25;
        voxelshape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            double width = Math.min(1.0, maxX - minX);
            double height = Math.min(1.0, maxY - minY);
            double depth = Math.min(1.0, maxZ - minZ);
            int stepX = Math.max(2, Mth.m_14165_((double)(width / d0)));
            int stepY = Math.max(2, Mth.m_14165_((double)(height / d0)));
            int stepZ = Math.max(2, Mth.m_14165_((double)(depth / d0)));
            for (int x = 0; x < stepX; ++x) {
                for (int y = 0; y < stepY; ++y) {
                    for (int z = 0; z < stepZ; ++z) {
                        double shiftX = ((double)x + 0.5) / (double)stepX;
                        double shiftY = ((double)y + 0.5) / (double)stepY;
                        double shiftZ = ((double)z + 0.5) / (double)stepZ;
                        double offX = shiftX * width + minX;
                        double offY = shiftY * height + minY;
                        double offZ = shiftZ * depth + minZ;
                        TerrainParticle fx = new TerrainParticle(mc.f_91073_, (double)pos.m_123341_() + offX, (double)pos.m_123342_() + offY, (double)pos.m_123343_() + offZ, shiftX - 0.5, shiftY - 0.5, shiftZ - 0.5, state, pos);
                        TintedSprite sprite = (TintedSprite)selector.get();
                        if (sprite == null || !(fx instanceof TextureSheetParticleAccessor)) continue;
                        TextureSheetParticleAccessor mixin = (TextureSheetParticleAccessor)fx;
                        int rgb = sprite.rgb;
                        float red = ColorHelper.getRed((int)rgb) * 0.6f;
                        float green = ColorHelper.getGreen((int)rgb) * 0.6f;
                        float blue = ColorHelper.getBlue((int)rgb) * 0.6f;
                        fx.m_107253_(red, green, blue);
                        mixin.callSetSprite(sprite.sprite());
                        mc.f_91061_.m_107344_((Particle)fx);
                    }
                }
            }
        });
    }

    public static void spawnHitFX(VoxelShape shape, BlockHitResult hit, Supplier<TintedSprite> selector) {
        BlockState state = WorldPartComponents.BLOCK.m_49966_();
        Minecraft mc = Minecraft.m_91087_();
        Direction side = hit.m_82434_();
        BlockPos pos = hit.m_82425_();
        int i = pos.m_123341_();
        int j = pos.m_123342_();
        int k = pos.m_123343_();
        float f = 0.1f;
        AABB aabb = shape.m_83215_();
        double d0 = (double)i + random.nextDouble() * (aabb.f_82291_ - aabb.f_82288_ - (double)0.2f) + (double)f + aabb.f_82288_;
        double d1 = (double)j + random.nextDouble() * (aabb.f_82292_ - aabb.f_82289_ - (double)0.2f) + (double)f + aabb.f_82289_;
        double d2 = (double)k + random.nextDouble() * (aabb.f_82293_ - aabb.f_82290_ - (double)0.2f) + (double)f + aabb.f_82290_;
        if (side == Direction.DOWN) {
            d1 = (double)j + aabb.f_82289_ - (double)0.1f;
        }
        if (side == Direction.UP) {
            d1 = (double)j + aabb.f_82292_ + (double)0.1f;
        }
        if (side == Direction.NORTH) {
            d2 = (double)k + aabb.f_82290_ - (double)0.1f;
        }
        if (side == Direction.SOUTH) {
            d2 = (double)k + aabb.f_82293_ + (double)0.1f;
        }
        if (side == Direction.WEST) {
            d0 = (double)i + aabb.f_82288_ - (double)0.1f;
        }
        if (side == Direction.EAST) {
            d0 = (double)i + aabb.f_82291_ + (double)0.1f;
        }
        TintedSprite sprite = selector.get();
        Particle fx = new TerrainParticle(mc.f_91073_, d0, d1, d2, 0.0, 0.0, 0.0, state, pos).m_107268_(0.2f).m_6569_(0.6f);
        if (sprite != null && sprite.sprite != null && fx instanceof TextureSheetParticleAccessor) {
            TextureSheetParticleAccessor mixin = (TextureSheetParticleAccessor)fx;
            int rgb = sprite.rgb();
            float red = ColorHelper.getRed((int)rgb) * 0.6f;
            float green = ColorHelper.getGreen((int)rgb) * 0.6f;
            float blue = ColorHelper.getBlue((int)rgb) * 0.6f;
            fx.m_107253_(red, green, blue);
            mixin.callSetSprite(sprite.sprite());
            mc.f_91061_.m_107344_(fx);
        }
    }

    public static void spawnLandingFX(BlockPos pos, VoxelShape shape, Vec3 spawnPos, int numberOfParticles, Supplier<TintedSprite> selector) {
        BlockState state = WorldPartComponents.BLOCK.m_49966_();
        Minecraft mc = Minecraft.m_91087_();
        AABB bounds = shape.m_83215_();
        float maxSpeed = 0.15f;
        for (int i = 0; i < numberOfParticles; ++i) {
            TintedSprite sprite = selector.get();
            double d6 = random.nextGaussian() * (double)maxSpeed;
            double d7 = random.nextGaussian() * (double)maxSpeed;
            double d8 = random.nextGaussian() * (double)maxSpeed;
            Vec3 finalPos = AABBUtils.randomPosWithin((AABB)bounds, (Random)random);
            TerrainParticle fx = new TerrainParticle(mc.f_91073_, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, d6, d7, d8, state, pos);
            if (sprite == null || sprite.sprite == null || !(fx instanceof TextureSheetParticleAccessor)) continue;
            TextureSheetParticleAccessor mixin = (TextureSheetParticleAccessor)fx;
            int rgb = sprite.rgb();
            float red = ColorHelper.getRed((int)rgb) * 0.6f;
            float green = ColorHelper.getGreen((int)rgb) * 0.6f;
            float blue = ColorHelper.getBlue((int)rgb) * 0.6f;
            fx.m_107253_(red, green, blue);
            mixin.callSetSprite(sprite.sprite());
            mc.f_91061_.m_107344_((Particle)fx);
        }
    }

    public static void spawnRunningFX(BlockPos pos, VoxelShape shape, Vec3 spawnPos, Vec3 particleMotion, Supplier<TintedSprite> selector) {
        BlockState state = WorldPartComponents.BLOCK.m_49966_();
        Minecraft mc = Minecraft.m_91087_();
        AABB bounds = shape.m_83215_();
        TintedSprite sprite = selector.get();
        double d6 = particleMotion.f_82479_;
        double d7 = particleMotion.f_82480_;
        double d8 = particleMotion.f_82481_;
        Vec3 finalPos = AABBUtils.randomPosWithin((AABB)bounds, (Random)random);
        TerrainParticle fx = new TerrainParticle(mc.f_91073_, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, d6, d7, d8, state, pos);
        if (sprite != null && sprite.sprite != null && fx instanceof TextureSheetParticleAccessor) {
            TextureSheetParticleAccessor mixin = (TextureSheetParticleAccessor)fx;
            int rgb = sprite.rgb();
            float red = ColorHelper.getRed((int)rgb) * 0.6f;
            float green = ColorHelper.getGreen((int)rgb) * 0.6f;
            float blue = ColorHelper.getBlue((int)rgb) * 0.6f;
            fx.m_107253_(red, green, blue);
            mixin.callSetSprite(sprite.sprite());
            mc.f_91061_.m_107344_((Particle)fx);
        }
    }

    public static void spawnHitFX(PartEntity pe, BlockHitResult hit) {
        Minecraft mc = Minecraft.m_91087_();
        if (IClientPartDefinitionExtensions.of(pe).addHitEffects(hit, pe, mc.f_91061_)) {
            return;
        }
        MultipartEffects.spawnHitFX(pe.getShape(), hit, MultipartEffects.defaultPartSpriteSelector(pe));
    }

    public static void spawnBreakFX(PartEntity part) {
        Minecraft mc = Minecraft.m_91087_();
        if (IClientPartDefinitionExtensions.of(part).addDestroyEffects(part, mc.f_91061_)) {
            return;
        }
        MultipartEffects.spawnBreakFX(part.container().pos(), part.getShape(), MultipartEffects.defaultPartSpriteSelector(part));
    }

    public static Supplier<TintedSprite> defaultPartSpriteSelector(PartEntity part) {
        BlockState state = WorldPartComponents.BLOCK.m_49966_();
        Minecraft mc = Minecraft.m_91087_();
        BakedModel model = mc.m_91289_().m_110907_().m_110893_(state);
        if (!(model instanceof IBakedMultipartModel)) {
            return () -> null;
        }
        IBakedMultipartModel bmm = (IBakedMultipartModel)model;
        BakedPartDefinitionModel bakedPart = bmm.getBakedPart(part);
        if (bakedPart == null) {
            return () -> null;
        }
        List<TintedSprite> particles = IClientPartDefinitionExtensions.of(part).gatherParticles(bakedPart, part, (tex, color) -> new TintedSprite(color != null ? color : 0xFFFFFF, bakedPart.getTexture((ResourceLocation)tex)));
        if (particles != null && !particles.isEmpty()) {
            return () -> (TintedSprite)particles.get(random.nextInt(particles.size()));
        }
        return () -> null;
    }

    public record TintedSprite(int rgb, TextureAtlasSprite sprite) {
        public TintedSprite(TextureAtlasSprite sprite) {
            this(0xFFFFFF, sprite);
        }
    }
}

