/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.client;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.PartEntity;
import org.zeith.multipart.client.MultipartEffects;
import org.zeith.multipart.client.model.BakedPartDefinitionModel;
import org.zeith.multipart.client.rendering.IPartRenderer;

public interface IClientPartDefinitionExtensions {
    public static final IClientPartDefinitionExtensions DEFAULT = new IClientPartDefinitionExtensions(){};

    public static IClientPartDefinitionExtensions of(PartEntity entity) {
        return IClientPartDefinitionExtensions.of(entity.definition());
    }

    public static IClientPartDefinitionExtensions of(PartDefinition definition) {
        IClientPartDefinitionExtensions e;
        Object object = definition.getRenderPropertiesInternal();
        return object instanceof IClientPartDefinitionExtensions ? (e = (IClientPartDefinitionExtensions)object) : DEFAULT;
    }

    default public IPartRenderer createRenderer(PartEntity part) {
        return null;
    }

    default public boolean addHitEffects(BlockHitResult target, PartEntity part, ParticleEngine manager) {
        return false;
    }

    default public boolean addDestroyEffects(PartEntity part, ParticleEngine manager) {
        return false;
    }

    default public void addLandingEffects(PartEntity part, VoxelShape shape, LivingEntity living, int numberOfParticles, AABB entityBb, Vec3 particlePos) {
        MultipartEffects.spawnLandingFX(part.container().pos(), shape, particlePos, numberOfParticles, MultipartEffects.defaultPartSpriteSelector(part));
    }

    default public void addRunningEffects(PartEntity part, VoxelShape shape, Entity living, AABB entityBb, Vec3 particlePos, Vec3 particleMotion) {
        MultipartEffects.spawnRunningFX(part.container().pos(), shape, particlePos, particleMotion, MultipartEffects.defaultPartSpriteSelector(part));
    }

    default public <T> List<T> gatherParticles(BakedPartDefinitionModel data, PartEntity part, BiFunction<ResourceLocation, Integer, T> spriteFactory) {
        return part.getParticleIcons(data.allParticles.keySet()).stream().map(tex -> spriteFactory.apply((ResourceLocation)tex, part.getTintForParticle((ResourceLocation)tex))).toList();
    }

    default public boolean getQuads(PartEntity part, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType, Consumer<BakedQuad> addQuad) {
        return false;
    }
}

