/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.zeith.hammerlib.api.io.NBTSerializationHelper;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.multipart.api.IndexedVoxelShape;
import org.zeith.multipart.api.PartContainer;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.api.placement.PartPlacement;
import org.zeith.multipart.api.placement.PartPos;
import org.zeith.multipart.client.MultipartEffects;

public abstract class PartEntity
extends CapabilityProvider<PartEntity> {
    protected final PartDefinition definition;
    protected final PartContainer container;
    protected final PartPlacement placement;
    protected final PartPos position;
    protected final int[] tintIndices;
    protected boolean syncDirty;
    protected boolean isShapeDirty;
    protected boolean isCollisionShapeDirty;
    protected VoxelShape cachedShape;
    protected VoxelShape cachedCollisionShape;

    public PartEntity(PartDefinition definition, PartContainer container, PartPlacement placement) {
        super(PartEntity.class);
        this.tintIndices = new int[definition.getTintIndexCount()];
        this.container = container;
        this.definition = definition;
        this.placement = placement;
        this.position = new PartPos(container.pos(), placement);
    }

    @NotNull
    public PartPlacement getMainPart() {
        return this.placement;
    }

    public Collection<ResourceLocation> getParticleIcons(Set<ResourceLocation> allowed) {
        return allowed;
    }

    public int[] getTintIndices() {
        return this.tintIndices;
    }

    public int getTintLayerColor(@Range(from=-1L, to=0x7FFFFFFFL) int tintLayer) {
        return 0xFFFFFF;
    }

    public int getTintForParticle(ResourceLocation texture) {
        return 0xFFFFFF;
    }

    protected VoxelShape updateCollisionShape() {
        return this.updateShape();
    }

    protected VoxelShape updateShape() {
        return this.placement.getExampleShape();
    }

    public void tickServer() {
        this.tickShared();
    }

    public void tickClient() {
        this.tickShared();
    }

    protected void tickShared() {
    }

    public Optional<Tuple2<BlockState, Function<BlockPos, BlockEntity>>> disassemblePart() {
        return Optional.empty();
    }

    public AbstractContainerMenu openContainer(Player player, int windowId) {
        return null;
    }

    public float getDestroySpeed(Player player) {
        return this.definition.destroySpeed;
    }

    public boolean isCorrectToolForDrops(@NotNull Player player) {
        return true;
    }

    public void onRemovedBy(Player player, boolean willHarvest) {
        this.onRemoved(player, willHarvest && !player.m_7500_(), false, true);
        SoundType sound = this.definition().getSoundType(this);
        player.m_9236_().m_5594_(player, this.container().pos(), sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
    }

    public void onRemoved(Player harvester, boolean spawnDrops, boolean playSound, boolean spawnParticles) {
        Level level;
        this.invalidateCaps();
        this.onRemove();
        if (playSound) {
            SoundType sound = this.definition().getSoundType(this);
            this.container().level().m_5594_(null, this.container().pos(), sound.m_56775_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        }
        if (spawnParticles) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MultipartEffects.spawnBreakFX(this));
        }
        if (spawnDrops && (level = this.container.level) instanceof ServerLevel) {
            ServerPlayer sp;
            ServerLevel sl = (ServerLevel)level;
            Level level2 = this.container.level();
            BlockPos pos = this.container.pos();
            LootParams.Builder loot = new LootParams.Builder(sl).m_287286_(LootContextParams.f_81463_, (Object)(harvester != null ? harvester.m_21205_() : ItemStack.f_41583_)).m_287289_(LootContextParams.f_81455_, (Object)harvester).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos));
            for (ItemStack drop : this.getDrops(harvester instanceof ServerPlayer ? (sp = (ServerPlayer)harvester) : null, loot)) {
                Block.m_49840_((Level)level2, (BlockPos)pos, (ItemStack)drop);
            }
        }
    }

    public List<ItemStack> getDrops(@Nullable ServerPlayer harvester, LootParams.Builder context) {
        return List.of();
    }

    public void neighborChanged(@Nullable Direction from, BlockPos neigborPos, BlockState neigborState, boolean waterlogged) {
        if (!this.canSurviveInWater() && waterlogged) {
            this.container.queuePartRemoval(this.placement, true, true, true);
        }
    }

    public int getWeakSignal(Direction towards) {
        return 0;
    }

    public int getStrongSignal(Direction towards) {
        return 0;
    }

    public CompoundTag serialize() {
        return NBTSerializationHelper.serialize((Object)((Object)this));
    }

    public void deserialize(CompoundTag tag) {
        NBTSerializationHelper.deserialize((Object)((Object)this), (CompoundTag)tag);
    }

    public final PartDefinition definition() {
        return this.definition;
    }

    public final PartContainer container() {
        return this.container;
    }

    public final PartPlacement placement() {
        return this.placement;
    }

    public boolean isShapeDirty() {
        return this.isShapeDirty || this.cachedShape == null;
    }

    public boolean isCollisionShapeDirty() {
        return this.isCollisionShapeDirty || this.cachedCollisionShape == null;
    }

    public IndexedVoxelShape getSelectionShape(Player player, BlockHitResult hit) {
        return new IndexedVoxelShape(0, this.getShape());
    }

    public final VoxelShape getShape() {
        if (this.isShapeDirty()) {
            this.cachedShape = this.updateShape();
            this.isShapeDirty = false;
        }
        return this.cachedShape;
    }

    public final VoxelShape getCollisionShape() {
        if (this.isCollisionShapeDirty()) {
            this.cachedCollisionShape = this.updateShape();
            this.isCollisionShapeDirty = false;
        }
        return this.cachedCollisionShape;
    }

    public VoxelShape getPartOccupiedShape() {
        return this.getCollisionShape();
    }

    public VoxelShape getPartOccupiedShapeWith(PartEntity toBePlaced, VoxelShape shapeOfEntity) {
        return this.getPartOccupiedShape();
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit, IndexedVoxelShape selection) {
        return InteractionResult.PASS;
    }

    public void attack(Player player, BlockHitResult hit, IndexedVoxelShape selection) {
    }

    public boolean syncDirty() {
        return this.syncDirty;
    }

    public void markSynced() {
        this.syncDirty = false;
    }

    public ItemStack getCloneItemStack(BlockHitResult target, Player player, IndexedVoxelShape selection) {
        return this.definition.getCloneItem();
    }

    public void animateTick(RandomSource random) {
    }

    public boolean isRedstoneSource() {
        return false;
    }

    public int getLightEmission() {
        return 0;
    }

    @Nullable
    public BlockState getRenderState() {
        return null;
    }

    @Nullable
    public BlockState getHardnessState() {
        return this.getRenderState();
    }

    public List<ResourceLocation> getRenderModels() {
        return List.of();
    }

    public void onPlaced() {
    }

    public void stepOn(Entity entity) {
    }

    public boolean isLadder(LivingEntity entity) {
        return false;
    }

    public boolean canHarvestPart(Player player) {
        BlockState state = this.getRenderState();
        if (state != null) {
            return state.canHarvestBlock((BlockGetter)this.container.level(), this.container.pos(), player);
        }
        return false;
    }

    public boolean canConnectRedstone(@Nullable Direction direction) {
        return false;
    }

    public BlockState getAppearance(BlockState state, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return state;
    }

    public boolean makesOpenTrapdoorAboveClimbable(BlockState trapdoorState) {
        return false;
    }

    public boolean canSurviveInWater() {
        return this.definition.canSurviveInWater(this);
    }

    public static VoxelShape createAttachmentShape(Direction dir, float minAxial, float maxAxial, float elevation) {
        VoxelShape ourShape;
        float invElevation = 1.0f - elevation;
        if (dir == null) {
            ourShape = Shapes.m_83040_();
        } else {
            ourShape = switch (dir) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> Shapes.m_166049_((double)minAxial, (double)0.0, (double)minAxial, (double)maxAxial, (double)elevation, (double)maxAxial);
                case Direction.UP -> Shapes.m_166049_((double)minAxial, (double)invElevation, (double)minAxial, (double)maxAxial, (double)1.0, (double)maxAxial);
                case Direction.NORTH -> Shapes.m_166049_((double)minAxial, (double)minAxial, (double)0.0, (double)maxAxial, (double)maxAxial, (double)elevation);
                case Direction.SOUTH -> Shapes.m_166049_((double)minAxial, (double)minAxial, (double)invElevation, (double)maxAxial, (double)maxAxial, (double)1.0);
                case Direction.WEST -> Shapes.m_166049_((double)0.0, (double)minAxial, (double)minAxial, (double)elevation, (double)maxAxial, (double)maxAxial);
                case Direction.EAST -> Shapes.m_166049_((double)invElevation, (double)minAxial, (double)minAxial, (double)1.0, (double)maxAxial, (double)maxAxial);
            };
        }
        return ourShape;
    }

    public boolean blocksPlacementFor(PartDefinition definition, PartPlacement definitionPosition) {
        return false;
    }

    public void onChunkUnloaded() {
        this.onRemove();
    }

    public void onLoad() {
    }

    public void onRemove() {
    }

    public PartPos pos() {
        return this.position;
    }

    public boolean isViewBlocking() {
        return false;
    }
}

