/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zeith.multipart.api.PartDefinition;
import org.zeith.multipart.client.model.BakedPartDefinitionModel;
import org.zeith.multipart.client.model.IPartModelBaker;
import org.zeith.multipart.init.PartRegistries;

public class PartDefinitionModel {
    public static final Logger LOG = LogManager.getLogger(PartDefinitionModel.class);
    protected final List<ResourceLocation> extraIcons = new ArrayList<ResourceLocation>();
    protected final List<ResourceLocation> partModels = new ArrayList<ResourceLocation>();
    protected final PartDefinition definition;
    private Object renderProperties;

    public PartDefinitionModel(PartDefinition definition) {
        this.definition = definition;
        this.initClient();
    }

    public PartDefinitionModel addParticleIcon(ResourceLocation icon) {
        if (!this.extraIcons.contains(icon)) {
            this.extraIcons.add(icon);
        }
        return this;
    }

    public PartDefinitionModel addSubmodel(ResourceLocation model) {
        if (!this.partModels.contains(model)) {
            this.partModels.add(model);
        }
        return this;
    }

    public List<ResourceLocation> getExtraIcons() {
        return this.extraIcons;
    }

    public List<ResourceLocation> getExtraModels() {
        return this.partModels;
    }

    public Object getRenderPropertiesInternal() {
        return this.renderProperties;
    }

    private void initClient() {
        if (FMLEnvironment.dist == Dist.CLIENT && !FMLLoader.getLaunchHandler().isData()) {
            this.initializeClient(properties -> {
                if (properties == this) {
                    throw new IllegalStateException("Don't extend IPartModelBaker in your part, use an anonymous class instead.");
                }
                this.renderProperties = properties;
            });
        }
    }

    protected void initializeClient(Consumer<IPartModelBaker> consumer) {
        consumer.accept(new DefaultPartModelBaker());
    }

    protected class DefaultPartModelBaker
    implements IPartModelBaker {
        BakedPartDefinitionModel mod;

        protected DefaultPartModelBaker() {
        }

        @Override
        public BakedPartDefinitionModel get() {
            return this.mod;
        }

        @Override
        public BakedPartDefinitionModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
            Map<ResourceLocation, TextureAtlasSprite> particleIcons = PartDefinitionModel.this.getExtraIcons().stream().map(path -> Map.entry(path, (TextureAtlasSprite)spriteGetter.apply(new Material(InventoryMenu.f_39692_, path)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<ResourceLocation, BakedModel> partModels = PartDefinitionModel.this.getExtraModels().stream().map(path -> {
                BakedModel mod = baker.bake(path, (ModelState)BlockModelRotation.X0_Y0, spriteGetter);
                if (mod == null) {
                    LOG.warn("Unable to load model {} for part definition {}", path, (Object)PartRegistries.partDefinitions().getKey((Object)PartDefinitionModel.this.definition));
                    return null;
                }
                return Map.entry(path, mod);
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            this.mod = new BakedPartDefinitionModel(particleIcons, partModels);
            return this.mod;
        }
    }
}

