/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.multipart;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.multipart.init.PartDefinitionsHM;
import org.zeith.multipart.init.PartRegistries;

@Mod(value="hammermultipart")
public class HammerMultipart {
    public static final Logger LOG = LoggerFactory.getLogger(HammerMultipart.class);
    public static final String MOD_ID = "hammermultipart";

    public HammerMultipart() {
        CommonMessages.printMessageOnIllegalRedistribution(HammerMultipart.class, (org.apache.logging.log4j.Logger)LogManager.getLogger(HammerMultipart.class), (String)"HammerMultipart", (String)"https://www.curseforge.com/minecraft/mc-mods/hammer-multipart");
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        LanguageAdapter.registerMod((String)MOD_ID);
        modBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent e) {
        if (PartDefinitionsHM.TORCH_PART.isRegistered()) {
            PartRegistries.registerFallbackPartPlacer(Items.f_42000_, PartDefinitionsHM.TORCH_PART::getPlacement);
            LOG.info("Registered torch multipart target.");
        }
        if (PartDefinitionsHM.SOUL_TORCH_PART.isRegistered()) {
            PartRegistries.registerFallbackPartPlacer(Items.f_42053_, PartDefinitionsHM.SOUL_TORCH_PART::getPlacement);
            LOG.info("Registered soul torch multipart target.");
        }
        if (PartDefinitionsHM.LADDER_PART.isRegistered()) {
            PartRegistries.registerFallbackPartPlacer(Items.f_41963_, PartDefinitionsHM.LADDER_PART::getPlacement);
            LOG.info("Registered ladder multipart target.");
        }
        if (PartDefinitionsHM.CHAIN_PART.isRegistered()) {
            PartRegistries.registerFallbackPartPlacer(Items.f_42026_, PartDefinitionsHM.CHAIN_PART::getPlacement);
            LOG.info("Registered chain multipart target.");
        }
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

