/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.traits;

import com.sammy.malum.common.capability.MalumLivingEntityDataCapability;
import com.sammy.malum.registry.common.AttributeRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.tools.TinkerTools;
import tcintegrations.util.ResourceLocationHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;

public class SoulStained
extends NoLevelsModifier
implements ProjectileHitModifierHook,
EquipmentChangeModifierHook,
MeleeHitModifierHook,
TooltipModifierHook {
    private static final AttributeModifier HELMET_SOUL_WARD_CAP = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.HELMET), "Helmet Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HELMET_SOUL_WARD_RECOVERY = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.HELMET), "Helmet Soul Ward Recovery", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_SOUL_WARD_CAP = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.CHESTPLATE), "Chestplate Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier CHESTPLATE_SOUL_WARD_RECOVERY = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.CHESTPLATE), "Chestplate Soul Ward Recovery", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SOUL_WARD_CAP = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.LEGGINGS), "Leggings Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier LEGGINGS_SOUL_WARD_RECOVERY = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.LEGGINGS), "Leggings Soul Ward Recovery", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_SOUL_WARD_CAP = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.BOOTS), "Boots Soul Ward Cap", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier BOOTS_SOUL_WARD_RECOVERY = new AttributeModifier((UUID)ArmorItem.f_265987_.get(ArmorItem.Type.BOOTS), "Boots Soul Ward Recovery", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier MELEE_PRIMARY_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("cd509ae0-3479-4665-b402-04e66c0ef3fd"), "Primary Magic Damage", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier AXE_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("353ec372-c40f-452b-8152-abace67ca5fd"), "Axe Magic Damage", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier HARVEST_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("4afa8ad7-bbb3-4c75-89c9-e488190790ba"), "Harvest Magic Damage", 2.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier OFFHAND_MELEE_PRIMARY_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("39dc8581-cbc0-4e3b-a7cd-2a016685c7a7"), "Offhand Primary Magic Damage", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier OFFHAND_AXE_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("1d4c724e-3797-463f-9e82-3e881f3511c7"), "Offhand Axe Magic Damage", 4.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier OFFHAND_HARVEST_MAGIC_DAMAGE = new AttributeModifier(UUID.fromString("8c109bf8-ed6e-4949-92cb-470c5e7b446f"), "Offhand Harvest Magic Damage", 2.0, AttributeModifier.Operation.ADDITION);
    private static final Component SOUL_WARD_CAPACITY = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("soul_stained.soul_ward_capacity")));
    private static final Component SOUL_WARD_RECOVERY_RATE = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("soul_stained.soul_ward_recovery_rate")));
    private static final Component PRIMARY_MAGIC_DAMAGE = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("soul_stained.primary_magic_damage")));
    private static final Component OFFHAND_MAGIC_DAMAGE = Component.m_237115_((String)Util.m_137492_((String)"modifier", (ResourceLocation)ResourceLocationHelper.resource("soul_stained.offhand_magic_damage")));

    protected void registerHooks(@NotNull ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.PROJECTILE_HIT, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.MELEE_HIT, ModifierHooks.TOOLTIP});
    }

    public void onEquip(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            this.changeEquipment(sp, context, false);
        }
    }

    public void onUnequip(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.m_9236_().f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            this.changeEquipment(sp, context, true);
        }
    }

    public float beforeMeleeHit(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        this.applyExposedSoulDuration(context.getLivingTarget());
        return super.beforeMeleeHit(tool, modifier, context, damage, baseKnockback, knockback);
    }

    public boolean onProjectileHitEntity(@NotNull ModifierNBT modifiers, @NotNull ModDataNBT persistentData, @NotNull ModifierEntry modifier, @NotNull Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        Entity entity = hit.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.applyExposedSoulDuration(living);
        }
        return false;
    }

    private void applyExposedSoulDuration(LivingEntity entity) {
        if (entity != null) {
            MalumLivingEntityDataCapability.getCapability((LivingEntity)entity).soulData.exposedSoulDuration = 200.0f;
        }
    }

    public void addTooltip(IToolStackView tool, @NotNull ModifierEntry modifier, @Nullable Player player, @NotNull List<Component> tooltip, @NotNull TooltipKey tooltipKey, @NotNull TooltipFlag tooltipFlag) {
        double soulWardCap = 0.0;
        double soulWardRecoveryRate = 0.0;
        double primaryMagicDamage = 0.0;
        double offhandMagicDamage = 0.0;
        if (tool.hasTag(TinkerTags.Items.HELMETS)) {
            soulWardCap = HELMET_SOUL_WARD_CAP.m_22218_();
            soulWardRecoveryRate = HELMET_SOUL_WARD_RECOVERY.m_22218_();
        } else if (tool.hasTag(TinkerTags.Items.CHESTPLATES)) {
            soulWardCap = CHESTPLATE_SOUL_WARD_CAP.m_22218_();
            soulWardRecoveryRate = CHESTPLATE_SOUL_WARD_RECOVERY.m_22218_();
        } else if (tool.hasTag(TinkerTags.Items.LEGGINGS)) {
            soulWardCap = LEGGINGS_SOUL_WARD_CAP.m_22218_();
            soulWardRecoveryRate = LEGGINGS_SOUL_WARD_RECOVERY.m_22218_();
        } else if (tool.hasTag(TinkerTags.Items.BOOTS)) {
            soulWardCap = BOOTS_SOUL_WARD_CAP.m_22218_();
            soulWardRecoveryRate = BOOTS_SOUL_WARD_RECOVERY.m_22218_();
        } else if (tool.hasTag(TinkerTags.Items.MELEE) || tool.hasTag(TinkerTags.Items.HARVEST)) {
            if (tool.getItem().equals(TinkerTools.broadAxe.m_5456_())) {
                offhandMagicDamage = OFFHAND_AXE_MAGIC_DAMAGE.m_22218_();
                primaryMagicDamage = AXE_MAGIC_DAMAGE.m_22218_();
            } else if (tool.hasTag(TinkerTags.Items.MELEE_PRIMARY)) {
                offhandMagicDamage = OFFHAND_MELEE_PRIMARY_MAGIC_DAMAGE.m_22218_();
                primaryMagicDamage = MELEE_PRIMARY_MAGIC_DAMAGE.m_22218_();
            } else if (tool.hasTag(TinkerTags.Items.MELEE) || tool.hasTag(TinkerTags.Items.HARVEST)) {
                offhandMagicDamage = OFFHAND_HARVEST_MAGIC_DAMAGE.m_22218_();
                primaryMagicDamage = HARVEST_MAGIC_DAMAGE.m_22218_();
            }
        }
        if (soulWardCap != 0.0) {
            TooltipModifierHook.addFlatBoost((Modifier)modifier.getModifier(), (Component)SOUL_WARD_CAPACITY, (double)soulWardCap, tooltip);
        }
        if (soulWardRecoveryRate != 0.0) {
            TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)SOUL_WARD_RECOVERY_RATE, (double)soulWardRecoveryRate, tooltip);
        }
        if (primaryMagicDamage != 0.0) {
            TooltipModifierHook.addFlatBoost((Modifier)modifier.getModifier(), (Component)PRIMARY_MAGIC_DAMAGE, (double)primaryMagicDamage, tooltip);
        }
        if (offhandMagicDamage != 0.0) {
            TooltipModifierHook.addFlatBoost((Modifier)modifier.getModifier(), (Component)OFFHAND_MAGIC_DAMAGE, (double)offhandMagicDamage, tooltip);
        }
    }

    public void changeEquipment(ServerPlayer sp, EquipmentChangeContext context, boolean remove) {
        AttributeInstance soulWardCap = sp.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get());
        AttributeInstance soulWardRecovery = sp.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_RECOVERY_RATE.get());
        AttributeInstance magicDamage = sp.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get());
        AttributeModifier soulWardCapModifier = null;
        AttributeModifier soulWardRecoveryModifier = null;
        AttributeModifier magicDamageModifier = null;
        boolean isArmor = false;
        boolean isTool = false;
        ItemStack stack = remove ? context.getOriginal() : context.getReplacement();
        switch (context.getChangedSlot()) {
            case FEET: {
                isArmor = true;
                soulWardCapModifier = BOOTS_SOUL_WARD_CAP;
                soulWardRecoveryModifier = BOOTS_SOUL_WARD_RECOVERY;
                break;
            }
            case LEGS: {
                isArmor = true;
                soulWardCapModifier = LEGGINGS_SOUL_WARD_CAP;
                soulWardRecoveryModifier = LEGGINGS_SOUL_WARD_RECOVERY;
                break;
            }
            case CHEST: {
                isArmor = true;
                soulWardCapModifier = CHESTPLATE_SOUL_WARD_CAP;
                soulWardRecoveryModifier = CHESTPLATE_SOUL_WARD_RECOVERY;
                break;
            }
            case HEAD: {
                isArmor = true;
                soulWardCapModifier = HELMET_SOUL_WARD_CAP;
                soulWardRecoveryModifier = HELMET_SOUL_WARD_RECOVERY;
                break;
            }
            case OFFHAND: 
            case MAINHAND: {
                if (!stack.m_204117_(TinkerTags.Items.MELEE) && !stack.m_204117_(TinkerTags.Items.HARVEST)) break;
                isTool = true;
            }
        }
        if (isArmor) {
            if (soulWardCap != null) {
                if (remove && soulWardCap.m_22109_(soulWardCapModifier)) {
                    soulWardCap.m_22130_(soulWardCapModifier);
                } else if (!soulWardCap.m_22109_(soulWardCapModifier)) {
                    soulWardCap.m_22125_(soulWardCapModifier);
                }
            }
            if (soulWardRecovery != null) {
                if (remove && soulWardRecovery.m_22109_(soulWardRecoveryModifier)) {
                    soulWardRecovery.m_22130_(soulWardRecoveryModifier);
                } else if (!soulWardRecovery.m_22109_(soulWardRecoveryModifier)) {
                    soulWardRecovery.m_22125_(soulWardRecoveryModifier);
                }
            }
        } else if (isTool) {
            if (stack.m_150930_(TinkerTools.broadAxe.m_5456_())) {
                magicDamageModifier = context.getChangedSlot() == EquipmentSlot.OFFHAND ? OFFHAND_AXE_MAGIC_DAMAGE : AXE_MAGIC_DAMAGE;
            } else if (stack.m_204117_(TinkerTags.Items.MELEE_PRIMARY)) {
                magicDamageModifier = context.getChangedSlot() == EquipmentSlot.OFFHAND ? OFFHAND_MELEE_PRIMARY_MAGIC_DAMAGE : MELEE_PRIMARY_MAGIC_DAMAGE;
            } else if (stack.m_204117_(TinkerTags.Items.MELEE) || stack.m_204117_(TinkerTags.Items.HARVEST)) {
                magicDamageModifier = context.getChangedSlot() == EquipmentSlot.OFFHAND ? OFFHAND_HARVEST_MAGIC_DAMAGE : HARVEST_MAGIC_DAMAGE;
            }
            if (magicDamage != null && magicDamageModifier != null) {
                if (remove && magicDamage.m_22109_(magicDamageModifier)) {
                    magicDamage.m_22130_(magicDamageModifier);
                } else if (!magicDamage.m_22109_(magicDamageModifier)) {
                    magicDamage.m_22125_(magicDamageModifier);
                }
            }
        }
    }
}

