/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.kleeslabs.KleeSlabsConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabDumpHandler {
    private static final Logger log = LoggerFactory.getLogger(SlabDumpHandler.class);

    public static void onServerStarted(ServerStartedEvent event) {
        if (KleeSlabsConfig.getActive().dumpSlabs) {
            SlabDumpHandler.dumpSlabs();
        }
    }

    public static void dumpSlabs() {
        String slabsOutput;
        Map<String, List<ResourceLocation>> slabsByMod = BuiltInRegistries.f_256975_.m_6566_().stream().filter(itemName -> itemName.m_135815_().endsWith("_slab") && !itemName.m_135815_().contains("vertical")).collect(Collectors.groupingBy(ResourceLocation::m_135827_));
        Map<String, List<ResourceLocation>> verticalSlabsByMod = BuiltInRegistries.f_256975_.m_6566_().stream().filter(itemName -> itemName.m_135815_().endsWith("_slab") && itemName.m_135815_().contains("vertical")).collect(Collectors.groupingBy(ResourceLocation::m_135827_));
        for (Map.Entry<String, List<ResourceLocation>> slabs : slabsByMod.entrySet()) {
            slabsOutput = slabs.getValue().stream().map(ResourceLocation::m_135815_).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Slabs from mod {}:\n{}", (Object)slabs.getKey(), (Object)slabsOutput);
        }
        for (Map.Entry<String, List<ResourceLocation>> verticalSlabs : verticalSlabsByMod.entrySet()) {
            slabsOutput = verticalSlabs.getValue().stream().map(ResourceLocation::m_135815_).map(it -> "\"" + it + "\"").sorted().collect(Collectors.joining(",\n"));
            log.info("Vertical slabs from mod {}:\n{}", (Object)verticalSlabs.getKey(), (Object)slabsOutput);
        }
    }
}

