/*
 * Decompiled with CFR 0.152.
 */
package github.cosmicdan.sleepingoverhaul.server;

import dev.architectury.networking.NetworkManager;
import github.cosmicdan.sleepingoverhaul.SleepingOverhaul;
import github.cosmicdan.sleepingoverhaul.mixin.proxy.PlayerMixinProxy;
import github.cosmicdan.sleepingoverhaul.server.ServerConfig;
import io.netty.buffer.Unpooled;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;

public class ServerState {
    private long timelapseEnd = -1L;
    private long timelapseStartNanos = 0L;
    private long timelapseTickCount = 0L;

    public ServerState() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)SleepingOverhaul.PACKET_TRY_REALLY_SLEEPING, this::tryReallySleepingRecv);
    }

    public boolean isTimelapseActive() {
        return this.timelapseEnd > -1L;
    }

    public boolean didTickTimelapse(ServerLevel serverLevel, long currentTime, long targetTime) {
        if (this.timelapseEnd == -1L) {
            this.timelapseEnd = targetTime;
            this.notifyPlayersTimelapseChange(serverLevel.m_6907_(), this.timelapseEnd);
            this.onTimelapseStart();
        } else if (currentTime >= this.timelapseEnd) {
            this.stopTimelapseNow(serverLevel);
        }
        return this.timelapseEnd > -1L;
    }

    public void onServerTickPost(MinecraftServer server) {
        if (this.timelapseEnd > -1L && ((Boolean)SleepingOverhaul.serverConfig.logTimelapsePerformanceStats.get()).booleanValue()) {
            ++this.timelapseTickCount;
        }
    }

    public void onTimelapseStart() {
        if (((Boolean)SleepingOverhaul.serverConfig.logTimelapsePerformanceStats.get()).booleanValue()) {
            this.timelapseStartNanos = Util.m_137569_();
            this.timelapseTickCount = 0L;
        }
    }

    public void onTimelapseEnd() {
        if (((Boolean)SleepingOverhaul.serverConfig.logTimelapsePerformanceStats.get()).booleanValue()) {
            double timelapseSeconds = (double)(Util.m_137569_() - this.timelapseStartNanos) / 1000000.0 / 1000.0;
            double ticksPerSecond = (double)this.timelapseTickCount / timelapseSeconds;
            SleepingOverhaul.LOGGER.info("Timelapse finished. Average TPS = {}; total time = {} seconds; total ticks = {}", new Object[]{ticksPerSecond, timelapseSeconds, this.timelapseTickCount});
        }
    }

    private void tryReallySleepingRecv(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        boolean reallySleeping = buf.readBoolean();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (reallySleeping && ((Boolean)SleepingOverhaul.serverConfig.bedRestEnabled.get()).booleanValue() && SleepingOverhaul.MODPLATFORM.canPlayerSleepNow(player)) {
                ((PlayerMixinProxy)player).so2_$setReallySleeping(true);
                serverPlayer.m_284548_().m_8878_();
            } else {
                FriendlyByteBuf bufPong = new FriendlyByteBuf(Unpooled.buffer());
                bufPong.writeBoolean(false);
                NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)SleepingOverhaul.PACKET_TRY_REALLY_SLEEPING, (FriendlyByteBuf)bufPong);
            }
        } else {
            SleepingOverhaul.LOGGER.warn("The player instance received from packet is not ServerPlayer, eh? Forge/Fabric changed stuff? Bed rest will be bugged...!");
        }
    }

    private void notifyPlayersTimelapseChange(Iterable<ServerPlayer> players, long timelapseEnd) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeLong(timelapseEnd);
        NetworkManager.sendToPlayers(players, (ResourceLocation)SleepingOverhaul.PACKET_TIMELAPSE_CHANGE, (FriendlyByteBuf)buf);
    }

    public void stopTimelapseNow(ServerLevel serverLevel) {
        if (this.isTimelapseActive()) {
            this.timelapseEnd = -1L;
            this.notifyPlayersTimelapseChange(serverLevel.m_6907_(), this.timelapseEnd);
            this.onTimelapseEnd();
        }
    }

    public float getPlayerHurtAdj(ServerPlayer player, DamageSource source, float amount) {
        float amountAdjusted = amount;
        if (this.isTimelapseActive()) {
            if (!source.m_269014_() && player.m_5803_()) {
                switch ((ServerConfig.AttackedWhileSleepingAction)((Object)SleepingOverhaul.serverConfig.timelapseSleepersDirectDamageAction.get())) {
                    case NoChange: {
                        break;
                    }
                    case InstantKill: {
                        amountAdjusted = Float.POSITIVE_INFINITY;
                        break;
                    }
                    case Invincible: {
                        amountAdjusted = Float.NaN;
                    }
                }
            } else if (!player.m_5803_() && ((Boolean)SleepingOverhaul.serverConfig.noDamageToNonSleepers.get()).booleanValue()) {
                amountAdjusted = Float.NaN;
            }
        }
        return amountAdjusted;
    }

    public boolean shouldPreventLivingTravel() {
        return this.isTimelapseActive() && (Boolean)SleepingOverhaul.serverConfig.disableLivingEntityTravel.get() != false;
    }

    public boolean shouldPreventNaturalSpawning() {
        return this.isTimelapseActive() && (Boolean)SleepingOverhaul.serverConfig.disableNaturalSpawning.get() != false;
    }

    public void setTimelapseEndForClient(long timelapseEndIn) {
        this.timelapseEnd = timelapseEndIn;
    }
}

