/*
 * Decompiled with CFR 0.152.
 */
package github.cosmicdan.sleepingoverhaul.mixin.injection;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import github.cosmicdan.sleepingoverhaul.SleepingOverhaul;
import github.cosmicdan.sleepingoverhaul.server.ServerConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
abstract class TimelapseMixinsCommonServerLevel
extends Level {
    protected TimelapseMixinsCommonServerLevel(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, Supplier<ProfilerFiller> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Shadow
    public abstract MinecraftServer m_7654_();

    @Shadow
    public abstract ServerLevel m_6018_();

    @Inject(method={"isNaturalSpawningAllowed(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public final void onNaturalSpawnCheckBlockPos(BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        if (SleepingOverhaul.serverState.shouldPreventNaturalSpawning()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isNaturalSpawningAllowed(Lnet/minecraft/world/level/ChunkPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public final void onNaturalSpawnCheckChunk(ChunkPos chunkPoss, CallbackInfoReturnable<Boolean> cir) {
        if (SleepingOverhaul.serverState.shouldPreventNaturalSpawning()) {
            cir.setReturnValue((Object)false);
        }
    }

    @WrapOperation(method={"announceSleepStatus"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/players/SleepStatus;areEnoughSleeping(I)Z")})
    public boolean onAreEnoughSleeping(SleepStatus instance, int requiredSleepPercentage, Operation<Boolean> original) {
        boolean areEnoughSleeping = (Boolean)original.call(new Object[]{instance, requiredSleepPercentage});
        if (!areEnoughSleeping && SleepingOverhaul.serverConfig.sleepAction.get() == ServerConfig.SleepAction.Timelapse) {
            SleepingOverhaul.serverState.stopTimelapseNow(this.m_6018_());
        }
        return areEnoughSleeping;
    }
}

