/*
 * Decompiled with CFR 0.152.
 */
package github.cosmicdan.sleepingoverhaul.client;

import dev.architectury.networking.NetworkManager;
import github.cosmicdan.sleepingoverhaul.IClientState;
import github.cosmicdan.sleepingoverhaul.SleepingOverhaul;
import github.cosmicdan.sleepingoverhaul.mixin.proxy.PlayerMixinProxy;
import io.netty.buffer.Unpooled;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ClientState
implements IClientState {
    private Button leaveButton = null;
    private Button sleepButton = null;
    private int timelapseCinematicStage = 0;

    public ClientState() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SleepingOverhaul.PACKET_TIMELAPSE_CHANGE, this::recvTimelapseChange);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)SleepingOverhaul.PACKET_TRY_REALLY_SLEEPING, this::recvTrySleepBounce);
    }

    private void recvTimelapseChange(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        long timelapseEnd = buf.readLong();
        this.setTimelapseCamera(context.getPlayer(), timelapseEnd > -1L);
        SleepingOverhaul.serverState.setTimelapseEndForClient(timelapseEnd);
    }

    private void recvTrySleepBounce(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        boolean reallySleeping = buf.readBoolean();
        if (!reallySleeping) {
            player.m_5661_((Component)Component.m_237115_((String)"gui.sleepingoverhaul.sleepNotPossibleNow"), true);
            ((PlayerMixinProxy)player).so2_$setReallySleeping(false);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ClientState.this.sleepButtonEnable(true);
                }
            }, 2000L);
        }
    }

    @Override
    public boolean isSleepButtonActive() {
        return this.sleepButton != null && this.sleepButton.m_142518_();
    }

    @Override
    public <T> void leaveBedButtonAssign(T buttonRaw) {
        if (buttonRaw instanceof Button) {
            Button button;
            this.leaveButton = button = (Button)buttonRaw;
        }
    }

    @Override
    public <T> void sleepButtonAssign(T buttonRaw) {
        if (buttonRaw instanceof Button) {
            Button button;
            this.sleepButton = button = (Button)buttonRaw;
        }
    }

    @Override
    public void setTimelapseCamera(Player player, boolean timelapseEnabled) {
        if (timelapseEnabled && player.m_5803_()) {
            if (this.timelapseCinematicStage == 0) {
                this.timelapseCinematicStage = 1;
            }
        } else {
            this.timelapseCinematicStage = 3;
        }
    }

    @Override
    public int getTimelapseCinematicStage() {
        return this.timelapseCinematicStage;
    }

    @Override
    public void advanceTimelapseCinematicStage() {
        this.timelapseCinematicStage = this.timelapseCinematicStage == 3 ? 0 : ++this.timelapseCinematicStage;
    }

    @Override
    public boolean isTimelapseCinematicActive() {
        return this.timelapseCinematicStage != 0;
    }

    @Override
    public void sleepButtonEnable(boolean enable) {
        if (this.sleepButton != null) {
            this.sleepButton.f_93623_ = enable;
        }
    }

    @Override
    public void onClickSleep() {
        if (this.isSleepButtonActive()) {
            SleepingOverhaul.clientState.sleepButtonEnable(false);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ((PlayerMixinProxy)player).so2_$setReallySleeping(true);
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeBoolean(true);
            NetworkManager.sendToServer((ResourceLocation)SleepingOverhaul.PACKET_TRY_REALLY_SLEEPING, (FriendlyByteBuf)buf);
        }
    }
}

