/*
 * Decompiled with CFR 0.152.
 */
package github.cosmicdan.sleepingoverhaul;

import com.mojang.logging.LogUtils;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import github.cosmicdan.sleepingoverhaul.IClientState;
import github.cosmicdan.sleepingoverhaul.IModPlatform;
import github.cosmicdan.sleepingoverhaul.TimelapseKillDamageSource;
import github.cosmicdan.sleepingoverhaul.client.ClientConfig;
import github.cosmicdan.sleepingoverhaul.client.ClientState;
import github.cosmicdan.sleepingoverhaul.server.ClientStateDummy;
import github.cosmicdan.sleepingoverhaul.server.ServerConfig;
import github.cosmicdan.sleepingoverhaul.server.ServerState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class SleepingOverhaul {
    public static final String MOD_ID = "sleepingoverhaul";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static IModPlatform MODPLATFORM;
    public static ServerState serverState;
    public static IClientState clientState;
    public static ServerConfig serverConfig;
    public static ClientConfig clientConfig;
    public static final ResourceLocation PACKET_TRY_REALLY_SLEEPING;
    public static final ResourceLocation PACKET_TIMELAPSE_CHANGE;

    public SleepingOverhaul(IModPlatform modPlatform) {
        MODPLATFORM = modPlatform;
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        serverConfig = (ServerConfig)specPairServer.getLeft();
        MODPLATFORM.registerConfig(ModConfig.Type.SERVER, (IConfigSpec<ForgeConfigSpec>)((IConfigSpec)specPairServer.getRight()));
        serverState = new ServerState();
        if (Platform.getEnvironment() == Env.CLIENT) {
            clientState = new ClientState();
            Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
            clientConfig = (ClientConfig)specPairClient.getLeft();
            MODPLATFORM.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec<ForgeConfigSpec>)((IConfigSpec)specPairClient.getRight()));
        } else {
            clientState = new ClientStateDummy();
        }
        EntityEvent.LIVING_HURT.register(SleepingOverhaul::onLivingHurt);
        TickEvent.SERVER_POST.register(serverState::onServerTickPost);
    }

    private static EventResult onLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        EventResult eventResult = EventResult.pass();
        if (serverState.isTimelapseActive() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!source.m_19385_().equals("sleepingoverhaul2.timelapseKill")) {
                float adjustedDamage = serverState.getPlayerHurtAdj(player, source, amount);
                if (Float.isNaN(adjustedDamage)) {
                    eventResult = EventResult.interruptFalse();
                } else if (Float.isInfinite(adjustedDamage)) {
                    eventResult = EventResult.interruptFalse();
                    player.m_6469_((DamageSource)new TimelapseKillDamageSource(), Float.MAX_VALUE);
                }
            }
        }
        return eventResult;
    }

    static {
        serverState = null;
        clientState = null;
        serverConfig = null;
        clientConfig = null;
        PACKET_TRY_REALLY_SLEEPING = new ResourceLocation(MOD_ID, "is_really_sleeping");
        PACKET_TIMELAPSE_CHANGE = new ResourceLocation(MOD_ID, "timelapse_change");
    }
}

