/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.screens;

import com.inventorypets.InventoryPets;
import com.inventorypets.capabilities.DataProvider;
import com.inventorypets.networking.PacketBiomeFinder;
import com.inventorypets.networking.PacketBiomeName;
import com.inventorypets.networking.PacketHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;

@OnlyIn(value=Dist.CLIENT)
public class BiomeFinderScreen
extends Screen {
    private static final int WIDTH = 179;
    private static final int HEIGHT = 151;
    private static String title = I18n.m_118938_((String)"gui.biometofind", (Object[])new Object[0]);
    private static final ResourceLocation GUI = new ResourceLocation("inventorypets:textures/gui/container/pet_namer.png");
    private String searchBiome;
    private ItemStack currentItem;
    LocalPlayer clientPlayer;
    private String s;
    private int biomeNum;
    private int arraySize;
    private String[] biomes2;
    private String[] biomePath;
    private BlockPos[] biomePos;
    protected MutableComponent cancelText;
    protected MutableComponent acceptText;
    protected Component leftText;
    protected Component rightText;
    boolean closeFlag;

    public BiomeFinderScreen(Inventory inventoryplayer) {
        super((Component)Component.m_237115_((String)title));
        this.clientPlayer = Minecraft.m_91087_().f_91074_;
        this.biomes2 = new String[2000];
        this.biomePath = new String[2000];
        this.biomePos = new BlockPos[2000];
        if (inventoryplayer.m_36056_().m_41782_()) {
            this.searchBiome = inventoryplayer.m_36056_().m_41783_().m_128461_("biometofind");
        }
        this.currentItem = inventoryplayer.m_36056_();
        this.cancelText = Component.m_237115_((String)"gui.cancel");
        this.acceptText = Component.m_237115_((String)"gui.inventorypets.find");
        this.leftText = Component.m_237113_((String)"<");
        this.rightText = Component.m_237113_((String)">");
        this.arraySize = 0;
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 179) / 2;
        int relY = (this.f_96544_ - 151) / 2;
        this.biomeNum = 0;
        Minecraft.m_91087_().f_91074_.getCapability(DataProvider.CAPS).ifPresent(props -> {
            String biomeString = props.getBiomeToSend();
            char delimiter = '^';
            for (int i = 0; i < biomeString.length(); ++i) {
                if (biomeString.charAt(i) != delimiter) continue;
                ++this.arraySize;
            }
            String[] biomes = new String[this.arraySize];
            int pathEnd = 0;
            int biomeEnd = 0;
            int tempX = 0;
            int tempY = 0;
            int tempZ = 0;
            int tempEnd = 0;
            this.closeFlag = false;
            for (int i = 0; i < this.arraySize; ++i) {
                pathEnd = biomeString.indexOf(":");
                this.biomePath[i] = biomeString.substring(0, pathEnd);
                biomeString = biomeString.substring(pathEnd + 1, biomeString.length());
                biomeEnd = biomeString.indexOf("|");
                biomes[i] = biomeString.substring(0, biomeEnd).trim();
                this.biomes2[i] = biomes[i];
                biomeString = biomeString.substring(biomeEnd + 1, biomeString.length());
                tempEnd = biomeString.indexOf("|");
                tempX = Integer.parseInt(biomeString.substring(0, tempEnd));
                biomeString = biomeString.substring(tempEnd + 1, biomeString.length());
                tempEnd = biomeString.indexOf("|");
                tempY = Integer.parseInt(biomeString.substring(0, tempEnd));
                biomeString = biomeString.substring(tempEnd + 1, biomeString.length());
                tempEnd = biomeString.indexOf("^");
                tempZ = Integer.parseInt(biomeString.substring(0, tempEnd));
                biomeString = biomeString.substring(tempEnd + 1, biomeString.length());
                this.biomePos[i] = new BlockPos(tempX, tempY, tempZ);
            }
            if (biomes.length > 0) {
                this.searchBiome = biomes[this.biomeNum];
                this.searchBiome = "biome." + this.biomePath[this.biomeNum] + "." + this.searchBiome;
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.cancelText, builder -> this.close()).m_252987_(relX + 10, relY + 72, 72, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.acceptText, builder -> this.searchForBiome()).m_252987_(relX + 94, relY + 72, 72, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.leftText, builder -> this.navLeft()).m_252987_(relX + 10, relY + 44, 14, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.rightText, builder -> this.navRight()).m_252987_(relX + 152, relY + 44, 14, 20).m_253136_());
                Object tmpDisplayName = I18n.m_118938_((String)this.searchBiome, (Object[])new Object[0]);
                if (((String)tmpDisplayName).length() > 20) {
                    tmpDisplayName = ((String)tmpDisplayName).substring(0, 20) + "..";
                }
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)tmpDisplayName), builder -> this.searchForBiome()).m_252987_(relX + 30, relY + 44, 116, 20).m_253136_());
            } else {
                InventoryPets.LOGGER.log(Level.DEBUG, "Error: no elements in biome array. Closing.");
                this.close();
            }
        });
    }

    public boolean m_7043_() {
        return false;
    }

    public Component m_142562_() {
        return Component.m_237115_((String)I18n.m_118938_((String)"gui.biometofind", (Object[])new Object[0]));
    }

    private void close() {
        this.f_96541_.m_91346_(null);
    }

    private void navLeft() {
        if (this.biomeNum - 1 >= 0) {
            Object tempName = this.biomes2[this.biomeNum - 1];
            Button chk = (Button)this.f_169369_.get(4);
            Object tmpDisplayName = I18n.m_118938_((String)(tempName = "biome." + this.biomePath[this.biomeNum - 1] + "." + (String)tempName), (Object[])new Object[0]);
            if (((String)tmpDisplayName).length() > 20) {
                tmpDisplayName = ((String)tmpDisplayName).substring(0, 20) + "..";
            }
            chk.m_93666_((Component)Component.m_237113_((String)tmpDisplayName));
            --this.biomeNum;
            return;
        }
        Object tempName = this.biomes2[this.arraySize - 1];
        Button chk = (Button)this.f_169369_.get(4);
        Object tmpDisplayName = I18n.m_118938_((String)(tempName = "biome." + this.biomePath[this.arraySize - 1] + "." + (String)tempName), (Object[])new Object[0]);
        if (((String)tmpDisplayName).length() > 20) {
            tmpDisplayName = ((String)tmpDisplayName).substring(0, 20) + "..";
        }
        chk.m_93666_((Component)Component.m_237113_((String)tmpDisplayName));
        this.biomeNum = this.arraySize - 1;
    }

    private void navRight() {
        if (this.biomeNum + 1 < this.arraySize) {
            Object tempName = this.biomes2[this.biomeNum + 1];
            Button chk = (Button)this.f_169369_.get(4);
            Object tmpDisplayName = I18n.m_118938_((String)(tempName = "biome." + this.biomePath[this.biomeNum + 1] + "." + (String)tempName), (Object[])new Object[0]);
            if (((String)tmpDisplayName).length() > 20) {
                tmpDisplayName = ((String)tmpDisplayName).substring(0, 20) + "..";
            }
            chk.m_93666_((Component)Component.m_237113_((String)tmpDisplayName));
            ++this.biomeNum;
            return;
        }
        Object tempName = this.biomes2[0];
        Button chk = (Button)this.f_169369_.get(4);
        Object tmpDisplayName = I18n.m_118938_((String)(tempName = "biome." + this.biomePath[0] + "." + (String)tempName), (Object[])new Object[0]);
        if (((String)tmpDisplayName).length() > 20) {
            tmpDisplayName = ((String)tmpDisplayName).substring(0, 20) + "..";
        }
        chk.m_93666_((Component)Component.m_237113_((String)tmpDisplayName));
        this.biomeNum = 0;
    }

    private void searchForBiome() {
        ItemStack getPet2 = this.currentItem;
        this.s = this.biomes2[this.biomeNum] + "|" + this.biomePos[this.biomeNum].m_123341_() + "|" + this.biomePos[this.biomeNum].m_123343_();
        if (!getPet2.m_41782_()) {
            getPet2.m_41751_(new CompoundTag());
        }
        getPet2.m_41783_().m_128359_("biometofind", this.s);
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        PacketHandler.sendToServer(new PacketBiomeFinder(this.s));
        int biomeX = 0;
        int biomeZ = 0;
        String biomeString = this.s;
        int sepLoc = this.s.indexOf("|");
        String biome = sepLoc >= 0 ? biomeString.substring(0, sepLoc).trim() : "";
        String biomeCoords = biomeString.substring(sepLoc + 1, biomeString.length());
        sepLoc = biomeCoords.indexOf("|");
        if (sepLoc >= 0) {
            biomeX = Integer.parseInt(biomeCoords.substring(0, sepLoc).trim());
            biomeZ = Integer.parseInt(biomeCoords.substring(sepLoc + 1, biomeCoords.length()).trim());
            double diffX = Math.abs((double)biomeX - clientPlayer.m_20185_());
            double diffZ = Math.abs((double)biomeZ - clientPlayer.m_20189_());
            int dist = (int)Math.sqrt(diffX * diffX + diffZ * diffZ);
            Holder holder = clientPlayer.m_9236_().m_204166_(new BlockPos(biomeX, 0, biomeZ));
            String biomeCheck = "biome." + ((ResourceKey)holder.m_203543_().get()).m_135782_().m_135827_() + "." + biome;
            BlockPos heightCheck = new BlockPos(biomeX, 0, biomeZ);
            BlockPos coordinates = clientPlayer.f_108545_.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, heightCheck);
            String biomeName = I18n.m_118938_((String)biomeCheck, (Object[])new Object[0]);
            getPet2.m_41783_().m_128359_("biomename", biomeName);
            PacketHandler.sendToServer(new PacketBiomeName(biomeName));
            clientPlayer.m_213846_((Component)Component.m_237115_((String)(I18n.m_118938_((String)"info.biome.hasfound", (Object[])new Object[0]) + "\u00a7l" + I18n.m_118938_((String)biomeCheck, (Object[])new Object[0]) + "\u00a7r" + I18n.m_118938_((String)"info.biome.about", (Object[])new Object[0]) + dist + I18n.m_118938_((String)"info.biome.meters", (Object[])new Object[0]))));
            boolean isCave = false;
            if (biome.contains("cave")) {
                isCave = true;
            }
            BiomeFinderScreen.LookAt(biomeX, coordinates.m_123342_(), biomeZ, (Player)clientPlayer, isCave);
        }
        this.f_96541_.m_91346_(null);
    }

    public static void LookAt(double px, double py, double pz, Player me, boolean isCave) {
        if (isCave) {
            me.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(px, 0.0, pz));
        } else {
            me.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3(px, py, pz));
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI);
        RenderSystem.disableBlend();
        int relX = (this.f_96543_ - 179) / 2;
        int relY = (this.f_96544_ - 151) / 2;
        guiGraphics.m_280218_(GUI, relX, relY, 0, 0, 179, 151);
        guiGraphics.m_280488_(this.f_96547_, title, this.f_96543_ / 2 - 80, relY + 10, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

