/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.handler;

import com.inventorypets.InventoryPets;
import com.inventorypets.networking.PacketHandler;
import com.inventorypets.networking.PacketTeleport;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.storage.LevelData;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;

public class TeleporterPositionHandler {
    public static void teleport(Player player, ServerLevel newDim, int x, int y, int z) {
        ServerPlayer playerMP = (ServerPlayer)player;
        if (!player.m_20159_()) {
            TeleporterPositionHandler.changeDimension((ServerPlayer)player, newDim, (ITeleporter)newDim.m_8871_());
            playerMP.m_6027_((double)x, (double)y, (double)z);
            PacketHandler.sendToPlayer(new PacketTeleport(x, y, z), playerMP);
            player.f_19789_ = 0.0f;
        }
    }

    @Nullable
    public static Entity changeDimension(ServerPlayer player, ServerLevel server, ITeleporter teleporter) {
        if (!ForgeHooks.onTravelToDimension((Entity)player, (ResourceKey)server.m_46472_())) {
            return null;
        }
        ServerLevel serverlevel = server.m_6018_();
        ResourceKey resourcekey = serverlevel.m_46472_();
        if (resourcekey == Level.f_46430_ && server.m_46472_() == Level.f_46428_ && teleporter.isVanilla()) {
            player.m_19877_();
            player.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
            if (!player.f_8944_) {
                player.f_8944_ = true;
            }
            return player;
        }
        LevelData leveldata = server.m_6106_();
        player.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(server.m_220362_(), server.m_46472_(), BiomeManager.m_47877_((long)server.m_7328_()), player.f_8941_.m_9290_(), player.f_8941_.m_9293_(), server.m_46659_(), server.m_8584_(), 3, player.m_219759_(), 0));
        player.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(leveldata.m_5472_(), leveldata.m_5474_()));
        PlayerList playerlist = player.f_8924_.m_6846_();
        playerlist.m_11289_(player);
        serverlevel.m_143261_(player, Entity.RemovalReason.CHANGED_DIMENSION);
        player.revive();
        Entity e = teleporter.placeEntity((Entity)player, serverlevel, server, player.m_146908_(), spawnPortal -> {
            serverlevel.m_46473_().m_6180_("moving");
            if (resourcekey == Level.f_46428_ && server.m_46472_() == Level.f_46429_ || !spawnPortal.booleanValue() || server.m_46472_() == Level.f_46430_) {
                // empty if block
            }
            serverlevel.m_46473_().m_7238_();
            serverlevel.m_46473_().m_6180_("placing");
            player.m_284127_(server);
            server.m_8817_(player);
            serverlevel.m_46473_().m_7238_();
            return player;
        });
        if (e != player) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Teleporter %s returned not the player entity but instead %s, expected PlayerEntity %s", teleporter, e, player));
        }
        player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
        playerlist.m_11229_(player, server);
        playerlist.m_11292_(player);
        for (MobEffectInstance mobeffectinstance : player.m_21220_()) {
            player.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(player.m_19879_(), mobeffectinstance));
        }
        boolean houseFlag = false;
        ItemStack itemchk = player.m_150109_().m_36056_();
        if (itemchk != ItemStack.f_41583_ && itemchk.m_41720_() == InventoryPets.PET_HOUSE.get()) {
            houseFlag = true;
        }
        if (!houseFlag && teleporter.playTeleportSound(player, serverlevel, server)) {
            player.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
        }
        ForgeEventFactory.firePlayerChangedDimensionEvent((Player)player, (ResourceKey)resourcekey, (ResourceKey)server.m_46472_());
        return player;
    }
}

