/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.CatVariantTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.world.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class SiamesePetEntity
extends Cat {
    public static final double TEMPT_SPEED_MOD = 0.6;
    public static final double WALK_SPEED_MOD = 0.8;
    public static final double SPRINT_SPEED_MOD = 1.33;
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_});
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(SiamesePetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_LYING = SynchedEntityData.m_135353_(SiamesePetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RELAX_STATE_ONE = SynchedEntityData.m_135353_(SiamesePetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(SiamesePetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Map<Integer, ResourceLocation> TEXTURE_BY_TYPE = (Map)Util.m_137469_((Object)Maps.newHashMap(), p_28140_ -> p_28140_.put(10, new ResourceLocation("textures/entity/cat/siamese.png")));
    private CatAvoidEntityGoal<Player> avoidPlayersGoal;
    @Nullable
    private TemptGoal temptGoal;
    private float lieDownAmount;
    private float lieDownAmountO;
    private float lieDownAmountTail;
    private float lieDownAmountOTail;
    private float relaxStateOneAmount;
    private float relaxStateOneAmountO;

    public SiamesePetEntity(EntityType<? extends Cat> entitySiamesePet, Level worldIn) {
        super(entitySiamesePet, worldIn);
    }

    protected void m_8099_() {
        this.temptGoal = new CatTemptGoal(this, 0.6, TEMPT_INGREDIENT, true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new CatRelaxOnOwnerGoal(this));
        this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(5, (Goal)new CatLieOnBedGoal((Cat)this, 1.1, 8));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new CatSitOnBlockGoal((Cat)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(9, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public static AttributeSupplier.Builder m_28168_() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.4f).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public int getCatType() {
        return (Integer)this.f_19804_.m_135370_(DATA_TYPE_ID);
    }

    public void setCatType(int p_28180_) {
        if (p_28180_ < 0 || p_28180_ >= 11) {
            p_28180_ = this.f_19796_.m_188503_(10);
        }
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)p_28180_);
    }

    public void m_28181_(boolean p_28182_) {
        this.f_19804_.m_135381_(IS_LYING, (Object)p_28182_);
    }

    public boolean m_28164_() {
        return (Boolean)this.f_19804_.m_135370_(IS_LYING);
    }

    public void m_28185_(boolean p_28186_) {
        this.f_19804_.m_135381_(RELAX_STATE_ONE, (Object)p_28186_);
    }

    public boolean m_28165_() {
        return (Boolean)this.f_19804_.m_135370_(RELAX_STATE_ONE);
    }

    public DyeColor m_28166_() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void m_28131_(DyeColor p_28132_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_28132_.m_41060_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)1);
        this.f_19804_.m_135372_(IS_LYING, (Object)false);
        this.f_19804_.m_135372_(RELAX_STATE_ONE, (Object)false);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    public void m_7380_(CompoundTag p_28156_) {
        super.m_7380_(p_28156_);
        p_28156_.m_128405_("CatType", this.getCatType());
        p_28156_.m_128344_("CollarColor", (byte)this.m_28166_().m_41060_());
    }

    public void m_7378_(CompoundTag p_28142_) {
        super.m_7378_(p_28142_);
        this.setCatType(p_28142_.m_128451_("CatType"));
        if (p_28142_.m_128425_("CollarColor", 99)) {
            this.m_28131_(DyeColor.m_41053_((int)p_28142_.m_128451_("CollarColor")));
        }
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d0 = this.m_21566_().m_24999_();
            if (d0 == 0.6) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d0 == 1.33) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_21824_()) {
            if (this.m_27593_()) {
                return SoundEvents.f_11792_;
            }
            return this.f_19796_.m_188503_(4) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11785_;
        }
        return SoundEvents.f_11786_;
    }

    public int m_8100_() {
        return 120;
    }

    public void m_28167_() {
        this.m_5496_(SoundEvents.f_11789_, this.m_6121_(), this.m_6100_());
    }

    protected SoundEvent m_7975_(DamageSource p_28160_) {
        return SoundEvents.f_11791_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    public boolean m_142535_(float p_148859_, float p_148860_, DamageSource p_148861_) {
        return false;
    }

    protected void m_142075_(Player p_148866_, InteractionHand p_148867_, ItemStack p_148868_) {
        if (this.m_6898_(p_148868_)) {
            this.m_5496_(SoundEvents.f_11788_, 1.0f, 1.0f);
        }
        super.m_142075_(p_148866_, p_148867_, p_148868_);
    }

    private float m_28169_() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity entity) {
        return entity.m_6469_(entity.m_9236_().m_269111_().m_269333_((LivingEntity)this), this.m_28169_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.temptGoal != null && this.temptGoal.m_25955_() && !this.m_21824_() && this.f_19797_ % 100 == 0) {
            this.m_5496_(SoundEvents.f_11790_, 1.0f, 1.0f);
        }
        this.m_28170_();
    }

    private void m_28170_() {
        if ((this.m_28164_() || this.m_28165_()) && this.f_19797_ % 5 == 0) {
            this.m_5496_(SoundEvents.f_11792_, 0.6f + 0.4f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()), 1.0f);
        }
        this.m_28171_();
        this.m_28172_();
    }

    private void m_28171_() {
        this.lieDownAmountO = this.lieDownAmount;
        this.lieDownAmountOTail = this.lieDownAmountTail;
        if (this.m_28164_()) {
            this.lieDownAmount = Math.min(1.0f, this.lieDownAmount + 0.15f);
            this.lieDownAmountTail = Math.min(1.0f, this.lieDownAmountTail + 0.08f);
        } else {
            this.lieDownAmount = Math.max(0.0f, this.lieDownAmount - 0.22f);
            this.lieDownAmountTail = Math.max(0.0f, this.lieDownAmountTail - 0.13f);
        }
    }

    private void m_28172_() {
        this.relaxStateOneAmountO = this.relaxStateOneAmount;
        this.relaxStateOneAmount = this.m_28165_() ? Math.min(1.0f, this.relaxStateOneAmount + 0.1f) : Math.max(0.0f, this.relaxStateOneAmount - 0.13f);
    }

    public float m_28183_(float p_28184_) {
        return Mth.m_14179_((float)p_28184_, (float)this.lieDownAmountO, (float)this.lieDownAmount);
    }

    public float m_28187_(float p_28188_) {
        return Mth.m_14179_((float)p_28188_, (float)this.lieDownAmountOTail, (float)this.lieDownAmountTail);
    }

    public float m_28116_(float p_28117_) {
        return Mth.m_14179_((float)p_28117_, (float)this.relaxStateOneAmountO, (float)this.relaxStateOneAmount);
    }

    public boolean m_7848_(Animal p_28127_) {
        if (!this.m_21824_()) {
            return false;
        }
        if (!(p_28127_ instanceof Cat)) {
            return false;
        }
        Cat cat = (Cat)p_28127_;
        return cat.m_21824_() && super.m_7848_(p_28127_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28134_, DifficultyInstance p_28135_, MobSpawnType p_28136_, @Nullable SpawnGroupData p_28137_, @Nullable CompoundTag p_28138_) {
        p_28137_ = super.m_6518_(p_28134_, p_28135_, p_28136_, p_28137_, p_28138_);
        boolean flag = p_28134_.m_46940_() > 0.9f;
        TagKey tagkey = flag ? CatVariantTags.f_215842_ : CatVariantTags.f_215841_;
        BuiltInRegistries.f_256754_.m_203431_(tagkey).flatMap(p_218136_ -> p_218136_.m_213653_(p_28134_.m_213780_())).ifPresent(p_262565_ -> this.m_28464_((CatVariant)p_262565_.m_203334_()));
        ServerLevel serverlevel = p_28134_.m_6018_();
        if (serverlevel.m_215010_().m_220491_(this.m_20183_(), StructureTags.f_215888_).m_73603_()) {
            this.m_28464_((CatVariant)BuiltInRegistries.f_256754_.m_123013_(CatVariant.f_218150_));
            this.m_21530_();
        }
        return p_28137_;
    }

    public InteractionResult m_6071_(Player p_28153_, InteractionHand p_28154_) {
        InteractionResult interactionresult1;
        ItemStack itemstack = p_28153_.m_21120_(p_28154_);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)p_28153_)) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(itemstack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)p_28153_)) {
                if (!(item instanceof DyeItem)) {
                    if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                        this.m_142075_(p_28153_, p_28154_, itemstack);
                        return InteractionResult.CONSUME;
                    }
                    InteractionResult interactionresult = super.m_6071_(p_28153_, p_28154_);
                    if (!interactionresult.m_19077_() || this.m_6162_()) {
                        this.m_21839_(!this.m_21827_());
                    }
                    return interactionresult;
                }
                DyeColor dyecolor = ((DyeItem)item).m_41089_();
                if (dyecolor != this.m_28166_()) {
                    this.m_28131_(dyecolor);
                    if (!p_28153_.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_21530_();
                    return InteractionResult.CONSUME;
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(p_28153_, p_28154_, itemstack);
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)p_28153_)) {
                this.m_21828_(p_28153_);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if ((interactionresult1 = super.m_6071_(p_28153_, p_28154_)).m_19077_()) {
            this.m_21530_();
        }
        return interactionresult1;
    }

    public boolean m_6898_(ItemStack p_28177_) {
        return TEMPT_INGREDIENT.test(p_28177_);
    }

    protected float m_6431_(Pose p_28150_, EntityDimensions p_28151_) {
        return p_28151_.f_20378_ * 0.5f;
    }

    public boolean m_6785_(double p_28174_) {
        return !this.m_21824_() && this.f_19797_ > 2400;
    }

    protected void m_5849_() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new CatAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
        }
    }

    public boolean m_20161_() {
        return this.m_20089_() == Pose.CROUCHING || super.m_20161_();
    }

    static class CatTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final Cat cat;

        public CatTemptGoal(SiamesePetEntity siamesePetEntity, double p_28220_, Ingredient p_28221_, boolean p_28222_) {
            super((PathfinderMob)siamesePetEntity, p_28220_, p_28221_, p_28222_);
            this.cat = siamesePetEntity;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.selectedPlayer == null && this.f_25924_.m_217043_().m_188503_(this.m_183277_(600)) == 0) {
                this.selectedPlayer = this.f_25925_;
            } else if (this.f_25924_.m_217043_().m_188503_(this.m_183277_(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean m_7497_() {
            return this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.f_25925_) ? false : super.m_7497_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.cat.m_21824_();
        }
    }

    static class CatRelaxOnOwnerGoal
    extends Goal {
        private final Cat cat;
        @Nullable
        private Player ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public CatRelaxOnOwnerGoal(SiamesePetEntity siamesePetEntity) {
            this.cat = siamesePetEntity;
        }

        public boolean m_8036_() {
            if (!this.cat.m_21824_()) {
                return false;
            }
            if (this.cat.m_21827_()) {
                return false;
            }
            LivingEntity livingentity = this.cat.m_269323_();
            if (livingentity instanceof Player) {
                this.ownerPlayer = (Player)livingentity;
                if (!livingentity.m_5803_()) {
                    return false;
                }
                if (this.cat.m_20280_((Entity)this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockpos = this.ownerPlayer.m_20183_();
                BlockState blockstate = this.cat.m_9236_().m_8055_(blockpos);
                if (blockstate.m_204336_(BlockTags.f_13038_)) {
                    this.goalPos = blockstate.m_61145_((Property)BedBlock.f_54117_).map(p_28209_ -> blockpos.m_121945_(p_28209_.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockpos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            for (Cat cat : this.cat.m_9236_().m_45976_(SiamesePetEntity.class, new AABB(this.goalPos).m_82400_(2.0))) {
                if (cat == this.cat || !cat.m_28164_() && !cat.m_28165_()) continue;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.cat.m_21824_() && !this.cat.m_21827_() && this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.goalPos != null) {
                this.cat.m_21837_(false);
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            this.cat.m_28181_(false);
            float f = this.cat.m_9236_().m_46942_(1.0f);
            if (this.ownerPlayer.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.m_9236_().m_213780_().m_188501_() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.m_28185_(false);
            this.cat.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource randomsource = this.cat.m_217043_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.m_122190_((Vec3i)this.cat.m_20183_());
            this.cat.m_20984_((double)(blockpos$mutableblockpos.m_123341_() + randomsource.m_188503_(11) - 5), (double)(blockpos$mutableblockpos.m_123342_() + randomsource.m_188503_(5) - 2), (double)(blockpos$mutableblockpos.m_123343_() + randomsource.m_188503_(11) - 5), false);
            blockpos$mutableblockpos.m_122190_((Vec3i)this.cat.m_20183_());
            LootTable loottable = this.cat.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78724_);
            LootParams lootparams = new LootParams.Builder((ServerLevel)this.cat.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.cat.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.cat).m_287235_(LootContextParamSets.f_81416_);
            for (ItemStack itemstack : loottable.m_287195_(lootparams)) {
                this.cat.m_9236_().m_7967_((Entity)new ItemEntity(this.cat.m_9236_(), (double)blockpos$mutableblockpos.m_123341_() - (double)Mth.m_14031_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), (double)blockpos$mutableblockpos.m_123342_(), (double)blockpos$mutableblockpos.m_123343_() + (double)Mth.m_14089_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), itemstack));
            }
        }

        public void m_8037_() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.m_21837_(false);
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
                if (this.cat.m_20280_((Entity)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.m_183277_(16)) {
                        this.cat.m_28181_(true);
                        this.cat.m_28185_(false);
                    } else {
                        this.cat.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
                        this.cat.m_28185_(true);
                    }
                } else {
                    this.cat.m_28181_(false);
                }
            }
        }
    }

    static class CatAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Cat cat;

        public CatAvoidEntityGoal(Cat p_28191_, Class<T> p_28192_, float p_28193_, double p_28194_, double p_28195_) {
            super((PathfinderMob)p_28191_, p_28192_, p_28193_, p_28194_, p_28195_, EntitySelector.f_20406_::test);
            this.cat = p_28191_;
        }

        public boolean m_8036_() {
            return !this.cat.m_21824_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.cat.m_21824_() && super.m_8045_();
        }
    }
}

