/*
 * Decompiled with CFR 0.152.
 */
package com.inventorypets.entities;

import com.inventorypets.config.InventoryPetsConfig;
import com.inventorypets.helper.AdvancementHelper;
import com.inventorypets.helper.ProxyHelper;
import com.inventorypets.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BedPetEntity
extends Mob
implements Enemy {
    private static final EntityDataAccessor<Integer> ID_SIZE = SynchedEntityData.m_135353_(BedPetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(BedPetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;
    private int deathDelay;
    public float targetSquish;
    public float squish;
    public float oSquish;

    public BedPetEntity(EntityType<? extends BedPetEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new SlimeMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SlimeFloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SlimeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new SlimeRandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SlimeKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.setSize(2, true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)2);
        this.f_19804_.m_135372_(OWNER_UNIQUE_ID, Optional.empty());
        this.deathDelay = 2400;
    }

    protected void setSize(int size, boolean resetHealth) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)size);
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_(200.0);
        this.m_21051_(Attributes.f_22279_).m_22100_((double)(0.2f + 0.1f * (float)size));
        this.m_21051_(Attributes.f_22281_).m_22100_(0.0);
        if (resetHealth) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = 0;
    }

    public int getSize() {
        return (Integer)this.f_19804_.m_135370_(ID_SIZE);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Size", this.getSize() - 1);
        compound.m_128379_("wasOnGround", this.wasOnGround);
        if (this.getOwnerId() == null) {
            compound.m_128359_("OwnerUUID", "");
        } else {
            compound.m_128359_("OwnerUUID", this.getOwnerId().toString());
        }
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public void m_7378_(CompoundTag compound) {
        String s;
        int i = compound.m_128451_("Size");
        if (i < 0) {
            i = 0;
        }
        this.setSize(i + 1, false);
        super.m_7378_(compound);
        this.wasOnGround = compound.m_128471_("wasOnGround");
        if (compound.m_128425_("OwnerUUID", 8)) {
            s = compound.m_128461_("OwnerUUID");
        } else {
            String s1 = compound.m_128461_("Owner");
            s = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s1).toString();
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected ParticleOptions getParticleType() {
        return ParticleTypes.f_123753_;
    }

    protected boolean isDespawnPeaceful() {
        return this.getSize() > 0;
    }

    public void m_8119_() {
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        this.oSquish = this.squish;
        super.m_8119_();
        --this.deathDelay;
        if (this.deathDelay <= 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (this.deathDelay == 90 || this.deathDelay == 60 || this.deathDelay == 30) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSoundEvents.overbell.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        } else if (this.deathDelay < 20) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123754_, this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.m_20096_() && !this.wasOnGround) {
            this.m_5496_(this.getSquishSound(), this.m_6121_(), ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.m_20096_() && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.m_20096_();
        this.alterSquishAmount();
        AABB range = new AABB(this.m_20185_() - 24.0, this.m_20186_() - 24.0, this.m_20189_() - 24.0, this.m_20185_() + 24.0, this.m_20186_() + 24.0, this.m_20189_() + 24.0);
        List entities = this.m_9236_().m_45976_(IronGolem.class, range);
        int esize = entities.size();
        for (int k = 0; k <= esize - 1; ++k) {
            IronGolem entitygolem;
            Entity entity = (Entity)entities.get(k);
            if (entity == null || (entitygolem = (IronGolem)entity).m_5448_() != this) continue;
            entitygolem.m_6710_(null);
            Vec3 vec3d = DefaultRandomPos.m_148407_((PathfinderMob)entitygolem, (int)10, (int)4, (Vec3)new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
            WorldBorder wb = this.m_9236_().m_6857_();
            if (vec3d == null || !wb.m_61937_(new BlockPos((int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_())) || !(this.m_20275_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_) >= this.m_20280_((Entity)entitygolem))) continue;
            entitygolem.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.0);
        }
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.f_19796_.m_188503_(20) + 10;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Player entityplayer = player;
        Level worldIn = player.m_9236_();
        if (itemstack != ItemStack.f_41583_ && itemstack.m_41720_() == Blocks.f_50041_.m_5456_()) {
            if (!entityplayer.m_9236_().m_46461_()) {
                ServerPlayer serverEntity;
                entityplayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 50, 2, false, false));
                ProxyHelper.Sleep(entityplayer);
                if (!worldIn.f_46443_ && !AdvancementHelper.hasAdvancement(serverEntity = (ServerPlayer)entityplayer, new ResourceLocation("minecraft", "adventure/sleep_in_bed"))) {
                    AdvancementHelper.unlockAdvancement(serverEntity, new ResourceLocation("minecraft", "adventure/sleep_in_bed"));
                }
                if (!entityplayer.m_7500_()) {
                    itemstack.m_41764_(itemstack.m_41613_() - 1);
                    if (itemstack.m_41613_() == 0) {
                        this.removeItem(entityplayer, itemstack);
                    }
                }
            }
            if (entityplayer.m_9236_().m_46461_() && !entityplayer.m_9236_().f_46443_) {
                entityplayer.m_213846_((Component)Component.m_237110_((String)"block.minecraft.bed.no_sleep", (Object[])new Object[0]));
            }
            return InteractionResult.SUCCESS;
        }
        if (!entityplayer.m_9236_().f_46443_ && itemstack == ItemStack.f_41583_) {
            if (((Boolean)InventoryPetsConfig.petsEatWholeItems.get()).booleanValue()) {
                entityplayer.m_213846_((Component)Component.m_237110_((String)"info.ip.livingbedinteracthc", (Object[])new Object[0]));
            } else {
                entityplayer.m_213846_((Component)Component.m_237110_((String)"info.ip.livingbedinteract", (Object[])new Object[0]));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void removeItem(Player ep, ItemStack removeitem) {
        Inventory inventoryPlayer = ep.m_150109_();
        for (int i = 0; i < 36; ++i) {
            ItemStack j;
            if (inventoryPlayer.m_8020_(i) == ItemStack.f_41583_ || (j = inventoryPlayer.m_8020_(i)) == ItemStack.f_41583_ || j.m_41720_() != removeitem.m_41720_()) continue;
            inventoryPlayer.m_6836_(i, ItemStack.f_41583_);
            break;
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (ID_SIZE.equals(key)) {
            this.m_6210_();
            this.m_146922_(this.f_20885_);
            this.f_20883_ = this.f_20885_;
            if (this.m_20069_() && this.f_19796_.m_188503_(20) == 0) {
                this.m_5841_();
            }
        }
        super.m_7350_(key);
    }

    public EntityType<? extends BedPetEntity> m_6095_() {
        return super.m_6095_();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.625f * sizeIn.f_20378_;
    }

    protected boolean isDealsDamage() {
        return false;
    }

    protected float getAttackDamage() {
        return (float)this.m_21051_(Attributes.f_22281_).m_22135_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12638_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.bed_yawn.get();
    }

    protected SoundEvent getSquishSound() {
        return SoundEvents.f_12591_;
    }

    protected ResourceLocation m_7582_() {
        return BuiltInLootTables.f_78712_;
    }

    protected float m_6121_() {
        return 0.4f * (float)this.getSize();
    }

    public int getVerticalFaceSpeed() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, this.m_6118_(), vec3.f_82481_);
        this.f_19812_ = true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33601_, DifficultyInstance p_33602_, MobSpawnType p_33603_, @Nullable SpawnGroupData p_33604_, @Nullable CompoundTag p_33605_) {
        int i = this.f_19796_.m_188503_(3);
        if (i < 2 && this.f_19796_.m_188501_() < 0.5f * p_33602_.m_19057_()) {
            ++i;
        }
        int j = 1 << i;
        this.setSize(j, true);
        return super.m_6518_(p_33601_, p_33602_, p_33603_, p_33604_, p_33605_);
    }

    protected SoundEvent getJumpSound() {
        return this.isTiny() ? (SoundEvent)ModSoundEvents.boing.get() : (SoundEvent)ModSoundEvents.boing.get();
    }

    float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(0.765f);
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    static class SlimeMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final BedPetEntity slime;
        private boolean isAggressive;

        public SlimeMoveControl(BedPetEntity slimeIn) {
            super((Mob)slimeIn);
            this.slime = slimeIn;
            this.yRot = 180.0f * this.slime.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRotIn, boolean aggressive) {
            this.yRot = yRotIn;
            this.isAggressive = aggressive;
        }

        public void setWantedMovement(double speedIn) {
            this.f_24978_ = speedIn;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.yRot, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.slime.getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.slime.m_21569_().m_24901_();
                        if (this.slime.doPlayJumpSound()) {
                            this.slime.m_5496_(this.slime.getJumpSound(), this.slime.m_6121_(), this.slime.getSoundPitch());
                        }
                    } else {
                        this.slime.f_20900_ = 0.0f;
                        this.slime.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    static class SlimeFloatGoal
    extends Goal {
        private final BedPetEntity slime;

        public SlimeFloatGoal(BedPetEntity anvilPetEntity) {
            this.slime = anvilPetEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            anvilPetEntity.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (this.slime.m_20069_() || this.slime.m_20077_()) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.slime.m_217043_().m_188501_() < 0.8f) {
                this.slime.m_21569_().m_24901_();
            }
            ((SlimeMoveControl)this.slime.m_21566_()).setWantedMovement(1.2);
        }
    }

    static class SlimeAttackGoal
    extends Goal {
        private final BedPetEntity slime;
        private int growTiredTimer;

        public SlimeAttackGoal(BedPetEntity anvilPetEntity) {
            this.slime = anvilPetEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return !this.slime.m_6779_(livingentity) ? false : this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8056_() {
            this.growTiredTimer = SlimeAttackGoal.m_186073_((int)300);
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!this.slime.m_6779_(livingentity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.slime.m_5448_();
            if (livingentity != null) {
                this.slime.m_21391_((Entity)livingentity, 10.0f, 10.0f);
            }
            ((SlimeMoveControl)this.slime.m_21566_()).setDirection(this.slime.m_146908_(), this.slime.isDealsDamage());
        }
    }

    static class SlimeRandomDirectionGoal
    extends Goal {
        private final BedPetEntity slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(BedPetEntity slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.slime.m_5448_() == null && (this.slime.m_20096_() || this.slime.m_20069_() || this.slime.m_20077_() || this.slime.m_21023_(MobEffects.f_19620_)) && this.slime.m_21566_() instanceof SlimeMoveControl;
        }

        public void m_8037_() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.m_183277_(40 + this.slime.m_217043_().m_188503_(60));
                this.chosenDegrees = this.slime.m_217043_().m_188503_(360);
            }
            ((SlimeMoveControl)this.slime.m_21566_()).setDirection(this.chosenDegrees, false);
        }
    }

    static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final BedPetEntity slime;

        public SlimeKeepOnJumpingGoal(BedPetEntity slimeIn) {
            this.slime = slimeIn;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Player entityplayer;
            boolean chkPlayer = false;
            if (this.slime.m_5448_() != null && this.slime.m_5448_() instanceof Player && (entityplayer = (Player)this.slime.m_5448_()) != null) {
                int x = (int)entityplayer.m_20185_();
                int z = (int)entityplayer.m_20189_();
                int thisx = (int)this.slime.m_20185_();
                int thisz = (int)this.slime.m_20189_();
                chkPlayer = Math.abs(thisx - x) >= 3 || Math.abs(thisz - z) >= 3;
            }
            return chkPlayer;
        }

        public void m_8037_() {
            ((SlimeMoveControl)this.slime.m_21566_()).setWantedMovement(1.0);
        }
    }
}

