/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;

public class JarFixer {
    public static void main(String[] args) {
        Path source = Paths.get(args[0], new String[0]);
        Path target = Paths.get(args[1], new String[0]);
        System.out.println("Source=" + source + ", Target=" + target);
        if (Files.notExists(target, new LinkOption[0])) {
            try {
                Files.copy(source, target, new CopyOption[0]);
                Files.deleteIfExists(source);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try (FileSystem targetSystem = FileSystems.newFileSystem(target);){
                FileSystem sourceSystem = FileSystems.newFileSystem(source);
                for (Path path : sourceSystem.getRootDirectories()) {
                    JarFixer.copy(path, T -> targetSystem.getPath(T.toString(), new String[0]));
                }
                sourceSystem.close();
                Files.deleteIfExists(source);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void copy(Path path, Function<Path, Path> provider) throws IOException {
        Files.walk(path, new FileVisitOption[0]).forEach(T -> {
            try {
                Path entry = (Path)provider.apply((Path)T);
                if (Files.exists(entry, new LinkOption[0]) && Files.isDirectory(entry, new LinkOption[0])) {
                    return;
                }
                Files.copy(T, entry, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

