/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import pregenerator.common.utils.misc.CommandWrapper;

public class CommandBuilder {
    Stack<CommandNode<CommandSourceStack>> queue = new ObjectArrayList();
    CommandNode<CommandSourceStack> current;

    public CommandBuilder(String base) {
        this.current = Commands.m_82127_((String)base).build();
    }

    public CommandBuilder(String name, ArgumentType<?> type) {
        this.current = Commands.m_82129_((String)name, type).build();
    }

    public CommandBuilder(ArgumentBuilder<CommandSourceStack, ?> arg) {
        this.current = arg.build();
    }

    public CommandBuilder merge(CommandBuilder builder) {
        return this.push(builder.build());
    }

    public CommandBuilder literal(String name) {
        return this.push((CommandNode<CommandSourceStack>)Commands.m_82127_((String)name).build());
    }

    public CommandBuilder literal(String name, Consumer<CommandWrapper> execute) {
        return this.push((CommandNode<CommandSourceStack>)((LiteralArgumentBuilder)Commands.m_82127_((String)name).executes(CommandBuilder.action(execute))).build());
    }

    public CommandBuilder arg(String name, ArgumentType<?> type) {
        return this.push((CommandNode<CommandSourceStack>)Commands.m_82129_((String)name, type).build());
    }

    public CommandBuilder arg(String name, ArgumentType<?> type, SuggestionProvider<CommandSourceStack> provider) {
        return this.push((CommandNode<CommandSourceStack>)Commands.m_82129_((String)name, type).suggests(provider).build());
    }

    public CommandBuilder arg(String name, ArgumentType<?> type, Consumer<CommandWrapper> execute) {
        return this.push((CommandNode<CommandSourceStack>)((RequiredArgumentBuilder)Commands.m_82129_((String)name, type).executes(CommandBuilder.action(execute))).build());
    }

    public CommandBuilder arg(String name, ArgumentType<?> type, SuggestionProvider<CommandSourceStack> suggestion, Consumer<CommandWrapper> execute) {
        return this.push((CommandNode<CommandSourceStack>)((RequiredArgumentBuilder)Commands.m_82129_((String)name, type).suggests(suggestion).executes(CommandBuilder.action(execute))).build());
    }

    private CommandBuilder push(CommandNode<CommandSourceStack> command) {
        this.current.addChild(command);
        this.queue.push(this.current);
        this.current = command;
        return this;
    }

    public CommandBuilder popTop() {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        return this;
    }

    public CommandBuilder pop() {
        this.current = (CommandNode)this.queue.pop();
        return this;
    }

    public CommandBuilder pop(int layers) {
        while (layers > 0) {
            this.current = (CommandNode)this.queue.pop();
            --layers;
        }
        return this;
    }

    public CommandNode<CommandSourceStack> build() {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        return this.current;
    }

    public static Command<CommandSourceStack> action(Consumer<CommandWrapper> action) {
        return T -> {
            action.accept(new CommandWrapper((CommandContext<CommandSourceStack>)T));
            return 0;
        };
    }

    public static SuggestionProvider<CommandSourceStack> suggestions(Supplier<Iterable<String>> provider) {
        return (T, V) -> SharedSuggestionProvider.m_82970_((Iterable)((Iterable)provider.get()), (SuggestionsBuilder)V);
    }

    public static SuggestionProvider<CommandSourceStack> resourceSuggestions(Supplier<Iterable<ResourceLocation>> provider) {
        return (T, V) -> SharedSuggestionProvider.m_82926_((Iterable)((Iterable)provider.get()), (SuggestionsBuilder)V);
    }

    public List<String> build(List<String> list) {
        while (!this.queue.isEmpty()) {
            this.current = (CommandNode)this.queue.pop();
        }
        this.build(this.current, "", list, false);
        return list;
    }

    private void build(CommandNode<?> node, String current, List<String> result, boolean optional) {
        String s = current + "\n" + node.getName() + (optional ? " (Optional)" : "");
        if (node.getCommand() != null) {
            result.add(s);
        }
        for (CommandNode subNode : node.getChildren()) {
            this.build(subNode, s, result, optional || node.getCommand() != null);
        }
    }
}

