/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pregenerator.base.api.TextUtil;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;

public class MemoryPacket {

    public static interface IMemoryReceiver {
        public void receivedMemory(ResourceKey<Level> var1, long var2, boolean var4);
    }

    public static class Answer
    implements IPregenPacket {
        ResourceKey<Level> dim;
        long memory;
        boolean free;

        public Answer() {
        }

        public Answer(ResourceKey<Level> dim, long memory, boolean free) {
            this.dim = dim;
            this.memory = memory;
            this.free = free;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.dim.m_135782_());
            buffer.writeLong(this.memory);
            buffer.writeBoolean(this.free);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
            this.memory = buffer.readLong();
            this.free = buffer.readBoolean();
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof IMemoryReceiver) {
                ((IMemoryReceiver)screen).receivedMemory(this.dim, this.memory, this.free);
            }
        }
    }

    public static class RequestUsed
    implements IPregenPacket {
        ResourceKey<Level> dim;

        public RequestUsed() {
        }

        public RequestUsed(ResourceKey<Level> dim) {
            this.dim = dim;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130085_(this.dim.m_135782_());
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_());
        }

        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new Answer(this.dim, TextUtil.getUsedMemory(this.dim), false), player);
        }
    }

    public static class RequestFree
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            NetworkManager.INSTANCE.sendToPlayer(new Answer((ResourceKey<Level>)Level.f_46428_, TextUtil.getFreeMemory(), true), player);
        }
    }
}

