/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import pregenerator.common.commands.arguments.ICoordinate;

public class RadiusArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0", "123", "0b", "123b");
    private final int minimum;
    private final int maximum;

    private RadiusArgument(int minimum, int maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public static RadiusArgument integer() {
        return RadiusArgument.integer(Integer.MIN_VALUE);
    }

    public static RadiusArgument integer(int min) {
        return RadiusArgument.integer(min, Integer.MAX_VALUE);
    }

    public static RadiusArgument integer(int min, int max) {
        return new RadiusArgument(min, max);
    }

    public static int getInteger(CommandContext<?> context, String name) {
        return (Integer)context.getArgument(name, Integer.TYPE);
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        int result = ICoordinate.parseNumber(reader);
        if (result < this.minimum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooLow().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.minimum);
        }
        if (result > this.maximum) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().createWithContext((ImmutableStringReader)reader, (Object)result, (Object)this.maximum);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RadiusArgument)) {
            return false;
        }
        RadiusArgument that = (RadiusArgument)o;
        return this.maximum == that.maximum && this.minimum == that.minimum;
    }

    public int hashCode() {
        return 31 * this.minimum + this.maximum;
    }

    public String toString() {
        if (this.minimum == Integer.MIN_VALUE && this.maximum == Integer.MAX_VALUE) {
            return "integer()";
        }
        if (this.maximum == Integer.MAX_VALUE) {
            return "integer(" + this.minimum + ")";
        }
        return "integer(" + this.minimum + ", " + this.maximum + ")";
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

