/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zeith.hammerlib.api.data.IDataNode;

public class XmlNode
implements IDataNode {
    protected final Map<String, String> attributes;
    protected final List<XmlNode> children;
    protected final String myName;

    public XmlNode(Node domNode) {
        String text;
        this.myName = domNode.getNodeName();
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (domNode.hasAttributes()) {
            NamedNodeMap attr = domNode.getAttributes();
            int len = attr.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = attr.item(i);
                attributes.put(node.getNodeName(), node.getNodeValue());
            }
        }
        if (!(text = domNode.getTextContent().trim().replace('\t', ' ')).isBlank()) {
            attributes.put("#text", text);
        }
        this.attributes = Map.copyOf(attributes);
        ArrayList<XmlNode> children = new ArrayList<XmlNode>();
        NodeList childNodes = domNode.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            if ("#text".equals(node.getNodeName())) continue;
            children.add(new XmlNode(node));
        }
        this.children = List.copyOf(children);
    }

    @Override
    @Nullable
    public Object get(int index) {
        return this.children.get(index);
    }

    @Override
    public int length() {
        return this.children.size();
    }

    @Override
    @Nullable
    public Object get(String key) {
        return this.attributes.get(key);
    }

    @Override
    @NotNull
    public Set<String> keys() {
        return this.attributes.keySet();
    }

    @Override
    public String getMyName() {
        return this.myName;
    }

    @Generated
    public String toString() {
        return "XmlNode(attributes=" + this.attributes + ", children=" + this.children + ", myName=" + this.getMyName() + ")";
    }
}

