/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.io.buf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.Consumer;
import org.zeith.hammerlib.util.configured.io.IoRunnable;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;

public class WritingBuf
implements IByteBuf {
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private final DataOutputStream out = new DataOutputStream(this.bytes);

    public WritingBuf() {
        this.bytes.reset();
    }

    public byte[] getAndReset() {
        byte[] buf = this.bytes.toByteArray();
        this.bytes.reset();
        return buf;
    }

    private void safeRun(IoRunnable task) {
        try {
            task.run();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeByte(int b) {
        this.safeRun(() -> this.out.writeByte(b));
    }

    @Override
    public void writeShort(int s) {
        this.safeRun(() -> this.out.writeShort(s));
    }

    @Override
    public void writeInt(int i) {
        this.safeRun(() -> this.out.writeInt(i));
    }

    @Override
    public void writeLong(long l) {
        this.safeRun(() -> this.out.writeLong(l));
    }

    @Override
    public void writeFloat(float f) {
        this.safeRun(() -> this.out.writeFloat(f));
    }

    @Override
    public void writeDouble(double d) {
        this.safeRun(() -> this.out.writeDouble(d));
    }

    @Override
    public void writeBytes(byte[] bytes, int off, int len) {
        this.safeRun(() -> this.out.write(bytes, off, len));
    }

    @Override
    public byte readByte() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readBytes(byte[] buf, int off, int length) {
        throw new UnsupportedOperationException();
    }

    public static byte[] encode(Consumer<IByteBuf> writer) {
        WritingBuf buf = new WritingBuf();
        writer.accept(buf);
        return buf.getAndReset();
    }
}

