/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.mixins;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.api.level.ISpoofedRecipeManager;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.event.recipe.SpoofRecipesEvent;
import org.zeith.hammerlib.util.java.Cast;

@Mixin(value={RecipeManager.class})
@Implements(value={@Interface(iface=ISpoofedRecipeManager.class, prefix="isrm$")})
public abstract class RecipeManagerMixin
implements ISpoofedRecipeManager {
    @Shadow(remap=false)
    @Final
    private ICondition.IContext context;
    @Shadow
    public Map<ResourceLocation, Recipe<?>> f_199900_;
    @Unique
    private final Multimap<ResourceLocation, ResourceLocation> hammerLib$SpoofByName = SpoofRecipesEvent.gather();

    @Inject(method={"byKey"}, at={@At(value="HEAD")}, cancellable=true)
    private void HammerLib_replaceRecipeId(ResourceLocation id, CallbackInfoReturnable<Optional<? extends Recipe<?>>> cir) {
        if (id == null || !this.hammerLib$SpoofByName.containsKey((Object)id)) {
            return;
        }
        Collection spofed = this.hammerLib$SpoofByName.get((Object)id);
        if (spofed.isEmpty()) {
            return;
        }
        Optional<Recipe<?>> recipe = this.findFirstRecipeHL(spofed);
        if (recipe.isPresent()) {
            cir.setReturnValue(recipe);
        } else {
            HammerLib.LOG.error("Failed to locate recipe with mapping {}={}", (Object)id, (Object)this.hammerLib$SpoofByName.get((Object)id));
        }
    }

    @Inject(method={"apply*"}, at={@At(value="TAIL")})
    public void HammerLib_reloadRecipes(Map<ResourceLocation, JsonElement> recipes, ResourceManager manager, ProfilerFiller profiler, CallbackInfo ci) {
        RecipeManager mgr = (RecipeManager)Cast.cast(this);
        RecipeHelper.injectRecipes(mgr, this.context);
    }

    public Multimap<ResourceLocation, ResourceLocation> isrm$getSpoofedRecipesHL() {
        return this.hammerLib$SpoofByName;
    }

    public Optional<? extends Recipe<?>> isrm$findFirstRecipeHL(Collection<ResourceLocation> ids) {
        return ids.stream().map(this.f_199900_::get).filter(Objects::nonNull).findFirst();
    }
}

