/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.proxy.HLConstants;

public class FingerprintCheckAdapter {
    public static final ResourceLocation SECURE_JAR_CHECK_ICONS = HLConstants.id("textures/gui/secure_jar.png");
    public static final int[] SECURE_JAR_CHECK_ICONS_SIZE = new int[]{8, 16};
    private static final List<Runnable> TASKS = Collections.synchronizedList(new ArrayList());
    private static final Map<FMLModContainer, CompletableFuture<FingerprintCheckResult>> CHECKS = new HashMap<FMLModContainer, CompletableFuture<FingerprintCheckResult>>();
    private static final Map<String, FMLModContainer> FML_MODS = new ConcurrentHashMap<String, FMLModContainer>();

    public static void service(FMLModContainer ctr) {
        IEventBus bus = ctr.getEventBus();
        FMLFingerprintCheckEvent evt = new FMLFingerprintCheckEvent(ctr);
        FML_MODS.putIfAbsent(ctr.getModId(), ctr);
        assert (bus != null);
        bus.addListener(e -> ctr.getEventBus().post((Event)evt));
        FingerprintCheckAdapter.enqueue(evt);
    }

    @Nullable
    public static FMLModContainer getFMLMod(String modid) {
        return FML_MODS.get(modid);
    }

    public static void loadComplete() {
        TASKS.forEach(Util.m_183991_()::submit);
    }

    public static FingerprintCheckResult getCheckResult(ModContainer mc) {
        CompletableFuture<FingerprintCheckResult> res = CHECKS.get(mc);
        if (res == null) {
            return FingerprintCheckResult.NOT_PRESENT;
        }
        if (res.isDone()) {
            return res.join();
        }
        return FingerprintCheckResult.NOT_PRESENT;
    }

    public static void enqueue(FMLFingerprintCheckEvent mod) {
        CHECKS.computeIfAbsent(mod.getModContainer(), m -> CompletableFuture.supplyAsync(() -> FingerprintCheckAdapter.check(mod), TASKS::add));
    }

    private static FingerprintCheckResult check(FMLFingerprintCheckEvent evt) {
        if (!evt.isJarSigned()) {
            return FingerprintCheckResult.NOT_PRESENT;
        }
        if (evt.getExpectedSignature() != null && evt.isViolated(evt.getExpectedSignature())) {
            return FingerprintCheckResult.FAILED;
        }
        if (evt.anyInvalidFiles()) {
            return FingerprintCheckResult.FAILED;
        }
        return FingerprintCheckResult.PASSED;
    }

    public static enum FingerprintCheckResult {
        PASSED(true, 0),
        FAILED(true, 8),
        NOT_PRESENT(false, 0);

        private final boolean iconVisible;
        private final int y;

        @Generated
        private FingerprintCheckResult(boolean iconVisible, int y) {
            this.iconVisible = iconVisible;
            this.y = y;
        }

        @Generated
        public boolean isIconVisible() {
            return this.iconVisible;
        }

        @Generated
        public int getY() {
            return this.y;
        }
    }
}

