/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.data.FlowQuery;
import org.zeith.hammerlib.client.flowgui.objects.GuiSlotLinkObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiRegistry;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;

@Namespace(value="hammerlib")
@FlowguiReader(value="slot")
public class FlowguiSlotReader
extends GuiReader<GuiSlotLinkObject> {
    @AllowJS
    @AllowedValues(value={"^0*[1-9]\\d*$"})
    @Required(value="(q) => q.slots.playerHotbarSlots[0]")
    public static final String KEY_INDEX = "index";

    @Override
    protected GuiSlotLinkObject readObject(KeyMap map, String name, IDataNode node) {
        Boolean cachingJS = map.getOrDefault(FlowguiRegistry.IS_CACHING_JS, false);
        FlowQuery query = map.get(FlowguiRegistry.QUERY);
        if (!(cachingJS.booleanValue() || query.container != null && query.slots != null)) {
            return null;
        }
        GuiSlotLinkObject link = new GuiSlotLinkObject(name);
        DriverContext ctx = this.getDriverContext(map, node, link);
        OptionalInt value = ComDrivers.readInt(ctx, KEY_INDEX).get();
        if (cachingJS.booleanValue()) {
            return link;
        }
        Supplier<RuntimeException> error = this.invalidField(node, KEY_INDEX);
        int slot = value.orElseThrow(error);
        NonNullList allSlots = query.container.f_38839_;
        if (slot < 0 || slot >= allSlots.size()) {
            throw error.get();
        }
        link.bindToSlot((Slot)allSlots.get(slot));
        return link;
    }
}

