/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Suggestions;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.data.FlowQuery;
import org.zeith.hammerlib.client.flowgui.objects.GuiEditBoxObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiRegistry;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.core.js.CallerSpec;

@Namespace(value="hammerlib")
@FlowguiReader(value="input")
public class FlowguiEditBoxReader
extends GuiReader<GuiEditBoxObject> {
    @AllowJS
    @AllowedValues(value={"^0*[1-9]\\d*$"})
    @Default(value="50")
    public static final String KEY_MAX_LENGTH = "max-length";
    @AllowJS
    @AllowedValues(value={"^#[a-fA-F0-9]{1,6}$"})
    @Default(value="#e0e0e0")
    public static final String KEY_TEXT_COLOR = "text-color";
    @AllowJS
    @AllowedValues(value={"^#[a-fA-F0-9]{1,6}$"})
    @Default(value="#707070")
    public static final String KEY_UNEDITABLE_TEXT_COLOR = "uneditable-text-color";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_BORDERED = "bordered";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_CAN_LOSE_FOCUS = "can-lose-focus";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_EDITABLE = "editable";
    @AllowJS
    public static final String KEY_HINT = "hint";
    @AllowJS
    @AllowedValues(value={})
    @Default(value="(q, str) => {}")
    public static final String KEY_ONCHANGED = "on-changed";
    public static final CallerSpec CONSUMER_SPEC = new CallerSpec("accept", false);

    @Override
    protected GuiEditBoxObject readObject(KeyMap map, String name, IDataNode node) {
        AtomicReference<GuiEditBoxObject> self = new AtomicReference<GuiEditBoxObject>();
        DriverContext ctx = this.getDriverContext(map, node, self);
        GuiEditBoxObject.EditBoxBuilder builder = GuiEditBoxObject.builder(name);
        String str = node.getString(KEY_ONCHANGED);
        StringConsumer eval = ctx.eval(StringConsumer.class, str, CONSUMER_SPEC);
        if (eval != null) {
            builder.responder(s -> eval.accept(ctx.query(), (String)s));
        }
        GuiEditBoxObject box = builder.build();
        self.set(box);
        ComDrivers.driveBool(ctx, KEY_BORDERED, true, false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.bordered(x$0);
        });
        ComDrivers.driveBool(ctx, KEY_CAN_LOSE_FOCUS, true, false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.canLoseFocus(x$0);
        });
        ComDrivers.driveInt(ctx, KEY_MAX_LENGTH, 50, false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.maxLength(x$0);
        });
        ComDrivers.driveBool(ctx, KEY_EDITABLE, true, false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.editable(x$0);
        });
        ComDrivers.driveComponent(ctx, KEY_HINT, (Component)Component.m_237119_(), false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.hint((Component)x$0);
        });
        ComDrivers.driveColor(ctx, KEY_TEXT_COLOR, 0xFFFFFF, false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.textColor(x$0);
        });
        ComDrivers.driveColor(ctx, KEY_UNEDITABLE_TEXT_COLOR, 0xFFFFFF, false, x$0 -> {
            GuiEditBoxObject cfr_ignored_0 = (GuiEditBoxObject)box.textColorUneditable(x$0);
        });
        return box;
    }

    @Override
    protected void finishBuilding(GuiEditBoxObject object, KeyMap map) {
        GuiRootObject pr = map.get(FlowguiRegistry.PREVIOUS_ROOT);
        if (pr == null) {
            return;
        }
        String mp = object.getMyPath();
        GuiEditBoxObject prev = pr.findByPath(mp, GuiEditBoxObject.class);
        if (object.wrapped != null && prev != null && prev.wrapped != null) {
            ((EditBox)object.wrapped).m_94144_(((EditBox)prev.wrapped).m_94155_());
        }
    }

    @FunctionalInterface
    public static interface StringConsumer {
        public void accept(FlowQuery var1, String var2);
    }
}

