/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Suggestions;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.objects.GuiButtonObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.util.java.Suppliers2;
import org.zeith.hammerlib.util.mcf.Resources;

@Namespace(value="hammerlib")
@FlowguiReader(value="button")
public class FlowguiButtonReader
extends GuiReader<GuiButtonObject> {
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    @Default(value="1")
    public static final String KEY_ALPHA = "alpha";
    @AllowJS
    @AllowedValues(value={"^#[a-fA-F0-9]{1,6}$"})
    @Default(value="#FFFFFF")
    public static final String KEY_TEXT_COLOR = "text-color";
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    public static final String KEY_PRESS_SOUND = "press-sound";
    @AllowJS
    @AllowedValues(value={"^(0|[1-9]\\d*)(\\.\\d+)?$"})
    public static final String KEY_PRESS_SOUND_PITCH = "press-sound-pitch";
    @AllowJS
    @Default(value="")
    public static final String KEY_LABEL = "label";
    @AllowJS
    @Default(value="")
    public static final String KEY_CALLBACK = "callback";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_ENABLED = "enabled";

    @Override
    protected GuiButtonObject readObject(KeyMap map, String name, IDataNode node) {
        AtomicReference<GuiButtonObject> self = new AtomicReference<GuiButtonObject>();
        DriverContext ctx = this.getDriverContext(map, node, self);
        GuiButtonObject.ButtonBuilder builder = GuiButtonObject.builder(name);
        Set<String> keys = node.keys();
        if (keys.contains(KEY_PRESS_SOUND)) {
            Supplier<String> fac = ComDrivers.readString(ctx, KEY_PRESS_SOUND);
            if (ComDrivers.isConstant(fac)) {
                builder.pressSound((Supplier<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)Resources.location(fac.get()))));
            } else {
                builder.pressSound(Suppliers2.map(fac, s -> SoundEvent.m_262824_((ResourceLocation)Resources.location(s))));
            }
        }
        GuiButtonObject button = builder.build();
        self.set(button);
        Runnable cbq = ComDrivers.readCallback(ctx, KEY_CALLBACK, false);
        button.callback = b -> cbq.run();
        ComDrivers.driveComponent(ctx, KEY_LABEL, (Component)Component.m_237119_(), false, button::setMessage);
        ComDrivers.driveColor(ctx, KEY_TEXT_COLOR, 0xFFFFFF, false, button::setPackedFGColor);
        ComDrivers.driveBool(ctx, KEY_ENABLED, true, false, button::setEnabled);
        ComDrivers.driveFloat(ctx, KEY_ALPHA, Float.valueOf(1.0f), false, alpha -> button.setAlpha(Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f)));
        ComDrivers.driveFloat(ctx, KEY_PRESS_SOUND_PITCH, Float.valueOf(1.0f), false, alpha -> button.setPressSoundPitch(Mth.m_14036_((float)alpha, (float)0.0f, (float)2.0f)));
        return button;
    }
}

