/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers.codec;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import org.zeith.hammerlib.api.io.serializers.BaseCodecSerializer;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.net.properties.PropertyBaseCodec;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;

public interface ICodecSerializer<T> {
    public Class<T> type();

    public Codec<T> codec();

    public T defaultValue();

    default public INBTSerializer<T> asSerializer() {
        return new BaseCodecSerializer<Object>(this.codec(), this::defaultValue);
    }

    default public PropertyBaseCodec<T> asProperty() {
        return new PropertyBaseCodec(this);
    }

    default public PropertyBaseCodec<T> asProperty(DirectStorage<T> storage) {
        return new PropertyBaseCodec<T>(this, storage);
    }

    public static <T> ICodecSerializer<T> of(Class<T> type, Codec<T> codec) {
        return ICodecSerializer.of(type, codec, Cast.constant(null));
    }

    public static <T> ICodecSerializer<T> of(final Class<T> type, final Codec<T> codec, final Supplier<T> defaultValue) {
        return new ICodecSerializer<T>(){

            @Override
            public Class<T> type() {
                return type;
            }

            @Override
            public Codec<T> codec() {
                return codec;
            }

            @Override
            public T defaultValue() {
                return defaultValue.get();
            }
        };
    }
}

