/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.inv;

import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import org.zeith.hammerlib.api.inv.ComplexProgressManager;
import org.zeith.hammerlib.net.properties.IProperty;

public interface ComplexProgressHandler {
    public ComplexProgressManager create();

    public void update(ComplexProgressManager var1);

    public void containerTick(ComplexProgressManager var1);

    public static ComplexProgressHandler withProperties(List<IProperty<?>> properties) {
        return ComplexProgressHandler.withProperties(0, properties);
    }

    public static ComplexProgressHandler withProperties(final int offset, final List<IProperty<?>> properties) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer((int)32));
        for (IProperty<?> property : properties) {
            property.write(buf);
        }
        final int cSize = buf.writerIndex();
        return new ComplexProgressHandler(){

            @Override
            public ComplexProgressManager create() {
                ComplexProgressManager cpm = new ComplexProgressManager(cSize, offset);
                for (int i = 0; i < properties.size(); ++i) {
                    cpm.registerProperty("p" + i, (IProperty)properties.get(i));
                }
                return cpm;
            }

            @Override
            public void update(ComplexProgressManager manager) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer((int)32));
                for (IProperty property : properties) {
                    property.write(buf);
                }
                manager.putBytes(0, buf.array(), 0, buf.writerIndex());
            }

            @Override
            public void containerTick(ComplexProgressManager manager) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])manager.getBytes()));
                for (IProperty property : properties) {
                    property.read(buf);
                }
            }
        };
    }
}

