/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.data;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.data.DelegatingDataNode;
import org.zeith.hammerlib.api.data.IDataNode;

public class DataNodeTransformer {
    public static IDataNode mergeAttributesFromParent(final IDataNode parent, IDataNode child) {
        return new DelegatingDataNode(child){

            @Override
            @Nullable
            public Object get(String key) {
                Object fromParent = parent.get(key);
                if (fromParent != null) {
                    return fromParent;
                }
                return super.get(key);
            }

            @Override
            @NotNull
            public Set<String> keys() {
                HashSet<String> child = new HashSet<String>(super.keys());
                child.addAll(parent.keys());
                return child;
            }
        };
    }

    public static IDataNode convertToComponent(IDataNode node, ResourceLocation comType) {
        final String compName = comType.toString();
        return new DelegatingDataNode(node){

            @Override
            public String getMyName() {
                return "com";
            }

            @Override
            @Nullable
            public Object get(String key) {
                if ("class".equals(key)) {
                    return compName;
                }
                return super.get(key);
            }
        };
    }

    public static IDataNode changeMyName(IDataNode node, final String newName) {
        return new DelegatingDataNode(node){

            @Override
            public String getMyName() {
                return newName;
            }
        };
    }

    public static IDataNode replaceProperty(IDataNode node, final String srcKey, final Object value) {
        return new DelegatingDataNode(node){

            @Override
            @Nullable
            public Object get(String key) {
                if (srcKey.equals(key)) {
                    return value;
                }
                return super.get(key);
            }
        };
    }
}

