/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting.itf;

import java.util.Collection;

@FunctionalInterface
public interface IRecipeReceiver<R> {
    public void onReceive(R var1);

    default public IRecipeReceiver<R> combine(IRecipeReceiver<R> other) {
        IRecipeReceiver t = this;
        return r -> {
            t.onReceive(r);
            other.onReceive(r);
        };
    }

    public static <T> IRecipeReceiver<T> combine(Collection<IRecipeReceiver<T>> receivers) {
        return r -> receivers.forEach(rcv -> rcv.onReceive(r));
    }
}

