/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting;

import org.zeith.hammerlib.api.crafting.IBaseIngredient;
import org.zeith.hammerlib.api.crafting.IngredientStack;
import org.zeith.hammerlib.api.energy.EnergyUnit;

public interface IEnergyIngredient<T extends Number>
extends IBaseIngredient {
    public T getAmount();

    default public Object getMeta() {
        return null;
    }

    default public double getStackCost(IngredientStack<? extends IEnergyIngredient<?>> stack) {
        return ((IEnergyIngredient)stack.ingredient).getRFCost() * (double)stack.amount;
    }

    default public double getRFCost() {
        if (this.getAmount() == null) {
            return 0.0;
        }
        return EnergyUnit.FE.convertFrom(((Number)this.getAmount()).doubleValue(), this.getUnit());
    }

    default public EnergyUnit getUnit() {
        return EnergyUnit.FE;
    }
}

