/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.api.blocks.redstone;

import org.jetbrains.annotations.Range;
import org.zeith.api.blocks.redstone.MCColor;

@FunctionalInterface
public interface IRedstoneBundleAccessor {
    public @Range(from=0L, to=65535L) int getSerializedBundleSignal();

    default public boolean hasSignal(MCColor color) {
        return IRedstoneBundleAccessor.hasSerialized(this.getSerializedBundleSignal(), color);
    }

    public static boolean hasSerialized(int colors, MCColor color) {
        int mask = color.bitmask;
        return (colors & mask) == mask;
    }

    public static int getSerializedBundleSignal(IRedstoneBundleAccessor bundle) {
        int r = 0;
        for (MCColor color : MCColor.values()) {
            if (!bundle.hasSignal(color)) continue;
            r |= color.bitmask;
        }
        return r;
    }

    public static int add(int serialized, MCColor ... colors) {
        for (MCColor color : colors) {
            serialized |= color.bitmask;
        }
        return serialized;
    }

    public static int remove(int serialized, MCColor ... colors) {
        for (MCColor color : colors) {
            serialized &= ~color.bitmask;
        }
        return serialized;
    }
}

