/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.tracking.benefits;

import com.tarinoita.solsweetpotato.ConfigHandler;
import com.tarinoita.solsweetpotato.SOLSweetPotatoConfig;
import com.tarinoita.solsweetpotato.tracking.CapabilityHandler;
import com.tarinoita.solsweetpotato.tracking.FoodList;
import com.tarinoita.solsweetpotato.tracking.benefits.Benefit;
import com.tarinoita.solsweetpotato.tracking.benefits.BenefitInfo;
import com.tarinoita.solsweetpotato.tracking.benefits.EffectBenefitsCapability;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="solapplepie")
public class BenefitsHandler {
    @SubscribeEvent
    public static void tickBenefits(LivingEvent.LivingTickEvent event) {
        if (!BenefitsHandler.checkEvent((LivingEvent)event)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.m_6084_()) {
            return;
        }
        EffectBenefitsCapability effectBenefits = EffectBenefitsCapability.get(player);
        effectBenefits.forEach(b -> b.onTick(player));
    }

    public static void updateBenefits(Player player, double diversity) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        if (foodList.getFoodsEaten() < SOLSweetPotatoConfig.minFoodsToActivate()) {
            return;
        }
        List<List<Benefit>> benefitsList = ConfigHandler.getBenefitsList();
        List<Double> thresholds = ConfigHandler.thresholds;
        EffectBenefitsCapability effectBenefits = EffectBenefitsCapability.get(player);
        effectBenefits.clear();
        for (int i = 0; i < thresholds.size(); ++i) {
            double thresh = thresholds.get(i);
            if (i >= benefitsList.size()) {
                return;
            }
            benefitsList.get(i).forEach(b -> {
                if (diversity >= thresh != b.isDetriment()) {
                    b.applyTo(player);
                } else {
                    b.removeFrom(player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        BenefitsHandler.updatePlayer((LivingEvent)event);
        CapabilityHandler.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        player.reviveCaps();
        BenefitsHandler.removeAllBenefits(player);
        player.invalidateCaps();
    }

    public static void removeAllBenefits(Player player) {
        List<List<Benefit>> benefitsList = ConfigHandler.getBenefitsList();
        benefitsList.forEach(bt -> bt.forEach(b -> b.removeFrom(player)));
    }

    public static void updatePlayer(LivingEvent event) {
        if (!BenefitsHandler.checkEvent(event)) {
            return;
        }
        Player player = (Player)event.getEntity();
        BenefitsHandler.updatePlayer(player);
    }

    public static void updatePlayer(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        FoodList foodList = FoodList.get(player);
        double diversity = foodList.foodDiversity();
        BenefitsHandler.updateBenefits(player, diversity);
    }

    public static boolean checkEvent(LivingEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return false;
        }
        Player player = (Player)event.getEntity();
        if (player.m_9236_().f_46443_) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        boolean isInSurvival = serverPlayer.f_8941_.m_9294_();
        return !SOLSweetPotatoConfig.limitProgressionToSurvival() || isInSurvival;
    }

    public static Pair<List<BenefitInfo>, List<BenefitInfo>> getBenefitInfo(double active_threshold, int foodEaten) {
        ArrayList activeBenefitInfo = new ArrayList();
        ArrayList inactiveBenefitInfo = new ArrayList();
        if (foodEaten < SOLSweetPotatoConfig.minFoodsToActivate()) {
            active_threshold = -1.0;
        }
        List<List<Benefit>> benefitsList = ConfigHandler.getBenefitsList();
        List<Double> thresholds = ConfigHandler.thresholds;
        for (int i = 0; i < thresholds.size(); ++i) {
            double thresh = thresholds.get(i);
            if (i >= benefitsList.size()) break;
            if (active_threshold >= thresh) {
                benefitsList.get(i).forEach(b -> activeBenefitInfo.add(new BenefitInfo(b.getType(), b.getName(), b.getValue(), thresh, b.isDetriment())));
                continue;
            }
            benefitsList.get(i).forEach(b -> inactiveBenefitInfo.add(new BenefitInfo(b.getType(), b.getName(), b.getValue(), thresh, b.isDetriment())));
        }
        activeBenefitInfo.sort((bi1, bi2) -> Boolean.compare(bi1.detriment, bi2.detriment));
        inactiveBenefitInfo.sort((bi1, bi2) -> Boolean.compare(bi1.detriment, bi2.detriment));
        return new ImmutablePair(activeBenefitInfo, inactiveBenefitInfo);
    }
}

