/*
 * Decompiled with CFR 0.152.
 */
package com.tarinoita.solsweetpotato.integration;

import com.tarinoita.solsweetpotato.SOLSweetPotato;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class Origins {
    private static Map<Player, Boolean> hasRestrictedDiet = new HashMap<Player, Boolean>();

    public static void cacheInvalidate(Player player) {
        hasRestrictedDiet.remove(player);
    }

    public static void clearCache() {
        hasRestrictedDiet.clear();
    }

    public static boolean hasRestrictedDiet(Player player) {
        if (hasRestrictedDiet.containsKey(player)) {
            return hasRestrictedDiet.get(player);
        }
        IOriginContainer originContainer = (IOriginContainer)IOriginContainer.get((Entity)player).orElse(null);
        if (originContainer == null) {
            SOLSweetPotato.LOGGER.warn("No IOriginContainer found for player: " + player.m_7755_().m_214077_());
            return false;
        }
        String vegetarian = "[origins:vegetarian]";
        String carnivore = "[origins:carnivore]";
        Registry originRegistry = OriginsAPI.getOriginsRegistry();
        for (ResourceKey originKey : originContainer.getOrigins().values()) {
            Origin origin = (Origin)originRegistry.m_6246_(originKey);
            if (origin == null) {
                SOLSweetPotato.LOGGER.warn("Player " + player.m_7755_().m_214077_() + " has unregistered Origin: " + originKey.toString());
                continue;
            }
            String originAsString = origin.toString();
            if (!originAsString.contains(vegetarian) && !originAsString.contains(carnivore)) continue;
            hasRestrictedDiet.put(player, Boolean.TRUE);
            return true;
        }
        hasRestrictedDiet.put(player, Boolean.FALSE);
        return false;
    }
}

