/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tconstruct;

import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningTierToolHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableBowItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableCrossbowItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;
import steve_gall.minecolonies_compatibility.api.common.tool.CustomizedToolSystem;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.init.ModToolTypes;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.TConstructToolHelper;

public class TConstructToolSystem
extends CustomizedToolSystem {
    public static final TConstructToolSystem INSTANCE = new TConstructToolSystem();

    private TConstructToolSystem() {
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return MineColoniesCompatibility.rl("tconstruct");
    }

    @Override
    public boolean isTool(@NotNull ItemStack stack) {
        return stack.m_41720_() instanceof IModifiable;
    }

    @Override
    public boolean isSword(@NotNull ItemStack stack) {
        return stack.m_41720_() instanceof ModifiableSwordItem;
    }

    @Override
    public boolean isSpecialTool(@NotNull ItemStack stack, @NotNull EquipmentTypeEntry toolType) {
        if (stack.m_41720_() instanceof ModifiableBowItem) {
            return toolType == ModEquipmentTypes.bow.get();
        }
        if (stack.m_41720_() instanceof ModifiableCrossbowItem) {
            return toolType == ModToolTypes.CROSSBOW.getToolType();
        }
        if (stack.m_150930_((Item)TinkerTools.flintAndBrick.get())) {
            return toolType == ModEquipmentTypes.flint_and_steel.get();
        }
        return false;
    }

    @Override
    public boolean isBroken(@NotNull ItemStack stack) {
        return ToolStack.from((ItemStack)stack).isBroken();
    }

    @Override
    public int getLevelUnclamped(@NotNull ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (tool.getStats().hasStat((IToolStat)ToolStats.HARVEST_TIER)) {
            Tier tier = MiningTierToolHook.getTier((IToolStackView)tool);
            return tier.m_6604_();
        }
        List<MaterialVariant> materialVariants = TConstructToolHelper.getRepairVariants((IToolStackView)tool);
        return materialVariants.stream().mapToInt(m -> m.get().getTier()).max().orElse(-1);
    }

    @Override
    public double getAttackDamage(@NotNull ItemStack stack) {
        ToolStack tool = ToolStack.from((ItemStack)stack);
        return ((Float)tool.getStats().get((IToolStat)ToolStats.ATTACK_DAMAGE)).doubleValue();
    }
}

