/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tconstruct;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.core.entity.ai.workers.crafting.EntityAIWorkBlacksmith;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import steve_gall.minecolonies_compatibility.api.common.repair.ToolSystemBrokenItem;
import steve_gall.minecolonies_compatibility.api.common.tool.CustomizedToolSystem;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.module.common.tconstruct.TConstructToolSystem;

public class BrokenItem
extends ToolSystemBrokenItem {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("tconstruct_broken_item");
    public static final Component SHORT_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("tconstruct_broken_item"));
    public static final Component LONG_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("tconstruct_broken_item.desc"));
    private static List<ItemStack> EXAMPLES;

    public BrokenItem(EntityAIWorkBlacksmith ai) {
        super(ai);
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public CustomizedToolSystem getToolSystem() {
        return TConstructToolSystem.INSTANCE;
    }

    public static BrokenItem deserialize(IFactoryController controller, CompoundTag tag) {
        return new BrokenItem(null);
    }

    public static void serialize(IFactoryController controller, CompoundTag tag, BrokenItem request) {
    }

    @NotNull
    public Component getShortDisplayString() {
        return SHORT_DISPLAY_STRING;
    }

    @NotNull
    public Component getLongDisplayString() {
        return LONG_DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (EXAMPLES == null) {
            EXAMPLES = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager().getListOfAllItems().stream().filter(TConstructToolSystem.INSTANCE::isTool).map(stack -> this.getBroken((ItemStack)stack)).toList();
        }
        return EXAMPLES;
    }

    private ItemStack getBroken(ItemStack stack) {
        stack = stack.m_41777_();
        ToolStack tool = ToolStack.from((ItemStack)stack);
        int durability = tool.getStats().getInt((IToolStat)ToolStats.DURABILITY);
        tool.setDamage(durability);
        return stack;
    }

    public BrokenItem copyWithCount(int newCount) {
        return new BrokenItem(this.getAI());
    }
}

