/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tacz;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGunner;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;
import steve_gall.minecolonies_compatibility.module.common.tacz.Ammo;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class GunnerGunAI
extends CustomizedAIGunner {
    public static final String TAG_KEY = MineColoniesCompatibility.rl("tacz_gun").toString();

    @Override
    @NotNull
    public BulletMode getBulletMode() {
        return BulletMode.ONLY_USE;
    }

    @Override
    public boolean test(@NotNull CustomizedAIContext context) {
        return super.test(context) && context.getWeapon().m_41720_() instanceof IGun;
    }

    @Override
    public void onSelected(@NotNull AbstractEntityCitizen user) {
        super.onSelected(user);
        ItemStack weapon = this.getMainHandItem(user);
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)user);
        operator.draw(() -> weapon);
    }

    @Override
    protected boolean testAmmo(@NotNull AbstractEntityCitizen user, @NotNull ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IAmmo) {
            IAmmo ammo = (IAmmo)item;
            ItemStack weapon = this.getMainHandItem(user);
            return ammo.isAmmoOfGun(weapon, stack);
        }
        return false;
    }

    @Override
    protected int getAmmoMinRequestCount(@NotNull AbstractEntityCitizen user) {
        IGun gun;
        CommonGunIndex gunIndex;
        ItemStack weapon = this.getMainHandItem(user);
        Item item = weapon.m_41720_();
        if (item instanceof IGun && (gunIndex = (CommonGunIndex)TimelessAPI.getCommonGunIndex((ResourceLocation)(gun = (IGun)item).getGunId(weapon)).orElse(null)) != null) {
            GunData gunData = gunIndex.getGunData();
            return gunData.getAmmoAmount() * 2;
        }
        return super.getAmmoMinRequestCount(user);
    }

    @Override
    @Nullable
    protected IDeliverableObject createAmmoRequest(@NotNull AbstractEntityCitizen user, int minCount) {
        IGun gun;
        CommonGunIndex gunIndex;
        ItemStack weapon = this.getMainHandItem(user);
        Item item = weapon.m_41720_();
        if (item instanceof IGun && (gunIndex = (CommonGunIndex)TimelessAPI.getCommonGunIndex((ResourceLocation)(gun = (IGun)item).getGunId(weapon)).orElse(null)) != null) {
            GunData gunData = gunIndex.getGunData();
            return new Ammo(gunData.getAmmoId(), minCount);
        }
        return null;
    }

    @Override
    protected boolean isAmmoRequest(@NotNull AbstractEntityCitizen user, @NotNull IDeliverableObject object) {
        IGun gun;
        CommonGunIndex gunIndex;
        ItemStack weapon = this.getMainHandItem(user);
        Item item = weapon.m_41720_();
        if (item instanceof IGun && (gunIndex = (CommonGunIndex)TimelessAPI.getCommonGunIndex((ResourceLocation)(gun = (IGun)item).getGunId(weapon)).orElse(null)) != null && object instanceof Ammo) {
            Ammo ammo = (Ammo)object;
            return gunIndex.getGunData().getAmmoId().equals((Object)ammo.getAmmoId());
        }
        return false;
    }

    @Override
    protected boolean isNeedRequestAmmo(@NotNull AbstractEntityCitizen user) {
        IGun gun;
        ItemStack weapon = this.getMainHandItem(user);
        Item item = weapon.m_41720_();
        if (item instanceof IGun && ((gun = (IGun)item).hasBulletInBarrel(weapon) || gun.getCurrentAmmoCount(weapon) > 0)) {
            return false;
        }
        return super.isNeedRequestAmmo(user);
    }

    @Override
    public boolean canRangedAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        return super.canRangedAttack(user, target);
    }

    @Override
    public boolean reload(@NotNull AbstractEntityCitizen user, boolean forRangedAttack) {
        if (!forRangedAttack) {
            IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)user);
            operator.reload();
        }
        return true;
    }

    @Override
    public void doRangedAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)user);
        ItemStack weapon = this.getMainHandItem(user);
        if (!operator.getSynIsAiming()) {
            operator.aim(true);
        }
        ShootResult result = operator.shoot(() -> ((AbstractEntityCitizen)user).m_146909_(), () -> ((AbstractEntityCitizen)user).m_146908_());
        if (result == ShootResult.NOT_DRAW || result == ShootResult.NOT_GUN) {
            operator.draw(() -> weapon);
        } else if (result == ShootResult.NO_AMMO) {
            operator.reload();
        } else if (result == ShootResult.NEED_BOLT) {
            operator.bolt();
        }
    }

    @Override
    public void onTargetReset(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        super.onTargetReset(user, target);
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)user);
        operator.aim(false);
    }

    @Override
    public void onTargetChange(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        super.onTargetChange(user, target);
        IGunOperator operator = IGunOperator.fromLivingEntity((LivingEntity)user);
        operator.aim(false);
    }

    @Override
    @Nullable
    protected AttackDelayConfig getAttackDealyConfig() {
        return null;
    }

    @Override
    @NotNull
    public String getTagKey() {
        return TAG_KEY;
    }
}

