/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.tacz;

import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public class Ammo
implements IDeliverableObject {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("tacz_ammo");
    public static final Component SHORT_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("tacz_ammo"));
    public static final Component LONG_DISPLAY_STRING = Component.m_237115_((String)MineColoniesCompatibility.tl("tacz_ammo.desc"));
    private ResourceLocation ammoId;
    private final int minCount;
    private List<ItemStack> example;

    public Ammo(ResourceLocation ammoId, int minCount) {
        this.ammoId = ammoId;
        this.minCount = minCount;
    }

    @NotNull
    public ResourceLocation getId() {
        return ID;
    }

    public static Ammo deserialize(IFactoryController controller, CompoundTag tag) {
        ResourceLocation ammoId = new ResourceLocation(tag.m_128461_("ammoId"));
        int minCount = tag.m_128451_("minCount");
        return new Ammo(ammoId, minCount);
    }

    public static void serialize(IFactoryController controller, CompoundTag tag, Ammo request) {
        tag.m_128359_("ammoId", request.ammoId.toString());
        tag.m_128405_("minCount", request.minCount);
    }

    @NotNull
    public Component getShortDisplayString() {
        return SHORT_DISPLAY_STRING;
    }

    @NotNull
    public Component getLongDisplayString() {
        return LONG_DISPLAY_STRING;
    }

    @NotNull
    public List<ItemStack> getDisplayStacks() {
        if (this.example == null) {
            this.example = Collections.singletonList(AmmoItemBuilder.create().setId(this.ammoId).build());
        }
        return this.example;
    }

    public Ammo copyWithCount(int newCount) {
        return new Ammo(this.ammoId, this.minCount);
    }

    public int getCount() {
        return this.minCount;
    }

    public ResourceLocation getAmmoId() {
        return this.ammoId;
    }

    public int getMinimumCount() {
        return this.minCount;
    }

    public boolean matches(@NotNull ItemStack stack) {
        IAmmo item;
        Item item2 = stack.m_41720_();
        return item2 instanceof IAmmo && (item = (IAmmo)item2).getAmmoId(stack).equals((Object)this.ammoId);
    }
}

