/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.refinedstorage;

import com.minecolonies.api.colony.IColony;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.cache.IStorageCacheListener;
import com.refinedmods.refinedstorage.api.storage.cache.InvalidateCause;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import com.refinedmods.refinedstorage.api.util.StackListResult;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.blockentity.config.IAccessType;
import com.refinedmods.refinedstorage.util.AccessTypeUtils;
import com.refinedmods.refinedstorage.util.LevelUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.colony.ColonyHelper;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;

public class CitizenGridNetworkNode
extends NetworkNode
implements IAccessType {
    private static final String TAG_LINK = "link";
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("citizen_grid");
    private final StorageView view;
    private final StorageListener listener;
    private AccessType accessType = AccessType.INSERT_EXTRACT;

    public CitizenGridNetworkNode(Level level, BlockPos pos) {
        super(level, pos);
        this.view = new StorageView();
        this.listener = new StorageListener();
    }

    public CitizenGridNetworkNode(CompoundTag tag, Level level, BlockPos pos) {
        this(level, pos);
        this.read(tag);
    }

    public int getEnergyUsage() {
        return (Integer)MineColoniesCompatibilityConfigServer.INSTANCE.modules.RS.citizen_grid_energyUsage.get();
    }

    public void onConnected(INetwork network) {
        super.onConnected(network);
        network.getItemStorageCache().addListener((IStorageCacheListener)this.listener);
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getItemStorageCache().removeListener((IStorageCacheListener)this.listener);
    }

    public boolean hasPermission(Permission permission) {
        NetworkStorageModule module = this.view.getLinkedModule();
        INetwork network = this.network;
        if (module == null || network == null) {
            return false;
        }
        IColony colony = module.getBuilding().getColony();
        FakePlayer owner = ColonyHelper.getFakeOwner(colony);
        return owner != null && network.getSecurityManager().hasPermission(permission, (Player)owner);
    }

    public void update() {
        super.update();
        this.view.onTick();
    }

    public StorageView getView() {
        return this.view;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        tag.m_128365_(TAG_LINK, (Tag)this.view.write());
        return tag;
    }

    public CompoundTag writeConfiguration(CompoundTag tag) {
        super.writeConfiguration(tag);
        AccessTypeUtils.writeAccessType((CompoundTag)tag, (AccessType)this.accessType);
        return tag;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        this.view.read(tag.m_128469_(TAG_LINK));
    }

    public void readConfiguration(CompoundTag tag) {
        super.readConfiguration(tag);
        this.accessType = AccessTypeUtils.readAccessType((CompoundTag)tag);
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getItemStorageCache().invalidate(InvalidateCause.DEVICE_CONFIGURATION_CHANGED);
        }
        this.markDirty();
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CitizenGridNetworkNode.this.level;
        }

        @Override
        public BlockPos getPos() {
            return CitizenGridNetworkNode.this.pos;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return CitizenGridNetworkNode.this.getItemStack();
        }

        @Override
        public boolean isActive() {
            return CitizenGridNetworkNode.this.canUpdate();
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CitizenGridNetworkNode.this.markDirty();
            LevelUtils.updateBlock((Level)CitizenGridNetworkNode.this.level, (BlockPos)CitizenGridNetworkNode.this.pos);
        }

        @Override
        public void unlink() {
            super.unlink();
            CitizenGridNetworkNode.this.markDirty();
            LevelUtils.updateBlock((Level)CitizenGridNetworkNode.this.level, (BlockPos)CitizenGridNetworkNode.this.pos);
        }

        @Override
        public boolean canExtract() {
            return CitizenGridNetworkNode.this.hasPermission(Permission.EXTRACT) && CitizenGridNetworkNode.this.accessType != AccessType.INSERT;
        }

        @Override
        public boolean canInsert() {
            return CitizenGridNetworkNode.this.hasPermission(Permission.INSERT) && CitizenGridNetworkNode.this.accessType != AccessType.EXTRACT;
        }

        @Override
        public Stream<ItemStack> getAllStacks() {
            INetwork network = CitizenGridNetworkNode.this.getNetwork();
            if (network == null) {
                return Stream.empty();
            }
            Collection entryList = network.getItemStorageCache().getList().getStacks();
            return entryList.stream().map(StackListEntry::getStack);
        }

        @Override
        public ItemStack extractItem(ItemStack stack, boolean simulate) {
            INetwork network = CitizenGridNetworkNode.this.getNetwork();
            if (network == null) {
                return ItemStack.f_41583_;
            }
            return network.extractItem(stack, stack.m_41613_(), simulate ? Action.SIMULATE : Action.PERFORM);
        }

        @Override
        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            INetwork network = CitizenGridNetworkNode.this.getNetwork();
            if (network == null) {
                return stack;
            }
            return network.insertItem(stack, stack.m_41613_(), simulate ? Action.SIMULATE : Action.PERFORM);
        }
    }

    public class StorageListener
    implements IStorageCacheListener<ItemStack> {
        public void onAttached() {
        }

        public void onChanged(StackListResult<ItemStack> result) {
            StorageView view = CitizenGridNetworkNode.this.getView();
            if (view.canEnqueue() && result.getChange() > 0) {
                CitizenGridNetworkNode.this.getView().enqueue((ItemStack)result.getStack());
            }
        }

        public void onChangedBulk(List<StackListResult<ItemStack>> results) {
            StorageView view = CitizenGridNetworkNode.this.getView();
            if (view.canEnqueue()) {
                view.enqueue(results.stream().filter(result -> result.getChange() > 0).map(e -> (ItemStack)e.getStack()).toList());
            }
        }

        public void onInvalidated() {
            CitizenGridNetworkNode.this.getView().requestAll();
        }
    }
}

