/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.oreberries;

import com.mrbysco.oreberriesreplanted.block.OreBerryBushBlock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;
import steve_gall.minecolonies_compatibility.mixin.common.oreberries.OreBerryBushBlockAccessor;

public class OreBerryFruit
extends CustomizedFruit {
    private final OreBerryBushBlock block;

    public OreBerryFruit(OreBerryBushBlock block) {
        this.block = block;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ForgeRegistries.BLOCKS.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return Arrays.asList(new ItemStack((ItemLike)this.block));
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return Arrays.asList(new ItemStack(((OreBerryBushBlockAccessor)this.block).invokeGetBerryItem()));
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == this.block;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        BlockState state = context.getState();
        return ((OreBerryBushBlock)state.m_60734_()).isMaxAge(state);
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelReader;
            BlockState state = context.getState();
            OreBerryBushBlock block = (OreBerryBushBlock)state.m_60734_();
            level.m_7731_(context.getPosition(), block.withAge(block.getMaxAge() - 1), 3);
            ItemStack drop = new ItemStack(((OreBerryBushBlockAccessor)block).invokeGetBerryItem(), level.f_46441_.m_188503_(3) + 1);
            return Collections.singletonList(drop);
        }
        return Collections.emptyList();
    }
}

