/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.functionalstorage;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.inventory.ControllerInventoryHandler;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import com.minecolonies.api.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.building.module.INetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.block.entity.IAccessDirectionHolder;
import steve_gall.minecolonies_compatibility.core.common.block.entity.INetworkStorageViewHolder;
import steve_gall.minecolonies_compatibility.core.common.building.module.AccessDirection;
import steve_gall.minecolonies_compatibility.core.common.building.module.NetworkStorageModule;
import steve_gall.minecolonies_compatibility.core.common.building.module.QueueNetworkStorageView;
import steve_gall.minecolonies_compatibility.core.common.item.ItemHandlerHelper2;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackCounter;
import steve_gall.minecolonies_compatibility.core.common.item.ItemStackKey;
import steve_gall.minecolonies_compatibility.module.common.functionalstorage.init.ModuleItems;

public class CitizenExtensionTile
extends ControllableDrawerTile<CitizenExtensionTile>
implements INetworkStorageViewHolder,
IAccessDirectionHolder {
    private final StorageView view;
    private final ItemStackCounter counter;
    private AccessDirection accessDirection = AccessDirection.INSERT_EXTRACT;

    public CitizenExtensionTile(BasicTileBlock<CitizenExtensionTile> base, BlockEntityType<CitizenExtensionTile> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
        this.view = new StorageView();
        this.counter = new ItemStackCounter();
        this.counter.addListener(this::onCounterChanged);
    }

    public int getBaseSize(int arg0) {
        return 0;
    }

    public int getStorageSlotAmount() {
        return 0;
    }

    public InventoryComponent<ControllableDrawerTile<CitizenExtensionTile>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<CitizenExtensionTile>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }
        }.setInputFilter((stack, integer) -> false).setOnSlotChanged((stack, integer) -> this.setNeedsUpgradeCache(true)).setSlotLimit(1);
    }

    public CitizenExtensionTile getSelf() {
        return this;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.view.read(compound.m_128469_("view"));
        this.accessDirection = AccessDirection.deserialize(compound.m_128423_("accessDirection"));
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("view", (Tag)this.view.write());
        compound.m_128365_("accessDirection", this.accessDirection.serialize());
    }

    @Override
    @NotNull
    public INetworkStorageView getNetworkStorageView() {
        return this.view;
    }

    @Override
    @NotNull
    public AccessDirection getAccessDirection() {
        return this.accessDirection;
    }

    @Override
    public void setAccessDirection(@NotNull AccessDirection value) {
        if (this.accessDirection != value) {
            this.accessDirection = value;
            this.view.requestAll();
            this.m_6596_();
        }
    }

    public void m_6596_() {
        Level level = this.m_58904_();
        if (level != null) {
            WorldUtil.markChunkDirty((Level)level, (BlockPos)this.m_58899_());
        }
        super.m_6596_();
    }

    public void update() {
        Iterable<Object2LongMap.Entry<ItemStackKey>> stacks = this.getStacks();
        this.counter.replace(stacks);
    }

    private void onCounterChanged(ItemStackKey key, long oldCount, long newCount) {
        if (oldCount < newCount) {
            this.view.enqueue(key.getStack(newCount));
        }
    }

    private Iterable<Object2LongMap.Entry<ItemStackKey>> getStacks() {
        StorageControllerTile<?> controller = this.getController();
        if (controller == null) {
            return Collections.emptyList();
        }
        ItemStackCounter counter = new ItemStackCounter();
        ControllerInventoryHandler inventoryHandler = controller.inventoryHandler;
        for (int i = 0; i < inventoryHandler.getSlots(); ++i) {
            ItemStack stack = inventoryHandler.getStackInSlot(i);
            if (stack == null || stack.m_41619_()) continue;
            ItemStackKey key = new ItemStackKey(stack);
            counter.insert(key, stack.m_41613_());
        }
        return counter.entrySet();
    }

    public StorageControllerTile<?> getController() {
        BlockPos pos = this.getControllerPos();
        if (pos == null) {
            return null;
        }
        return TileUtil.getTileEntity((BlockGetter)this.f_58857_, (BlockPos)pos, StorageControllerTile.class).orElse(null);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, CitizenExtensionTile self) {
        super.serverTick(level, pos, state, (ControllableDrawerTile)self);
        if (level.m_46467_() % (long)FunctionalStorageConfig.UPGRADE_TICK == 0L) {
            this.update();
        }
        this.view.onTick();
    }

    public class StorageView
    extends QueueNetworkStorageView {
        @Override
        public Level getLevel() {
            return CitizenExtensionTile.this.f_58857_;
        }

        @Override
        public BlockPos getPos() {
            return CitizenExtensionTile.this.f_58858_;
        }

        @Override
        @Nullable
        public Direction getDirection() {
            return null;
        }

        @Override
        @NotNull
        public ItemStack getIcon() {
            return new ItemStack((ItemLike)ModuleItems.CITIZEN_EXTENSION.get());
        }

        @Override
        public boolean isActive() {
            return CitizenExtensionTile.this.getControllerPos() != null;
        }

        @Override
        public boolean canExtract() {
            return CitizenExtensionTile.this.getAccessDirection().canExtract();
        }

        @Override
        public boolean canInsert() {
            return CitizenExtensionTile.this.getAccessDirection().canInsert();
        }

        @Override
        @NotNull
        public Stream<ItemStack> getAllStacks() {
            return CitizenExtensionTile.this.counter.entrySet().stream().map(e -> ((ItemStackKey)e.getKey()).getStack(e.getLongValue()));
        }

        @Override
        public void link(NetworkStorageModule module) {
            super.link(module);
            CitizenExtensionTile.this.m_6596_();
        }

        @Override
        public void unlink() {
            super.unlink();
            CitizenExtensionTile.this.m_6596_();
        }

        @Override
        @NotNull
        public ItemStack extractItem(@NotNull ItemStack stack, boolean simulate) {
            StorageControllerTile<?> controller = CitizenExtensionTile.this.getController();
            if (controller == null) {
                return ItemStack.f_41583_;
            }
            return ItemHandlerHelper2.extractItem((IItemHandler)controller.inventoryHandler, stack, simulate);
        }

        @Override
        @NotNull
        public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
            StorageControllerTile<?> controller = CitizenExtensionTile.this.getController();
            if (controller == null) {
                return stack;
            }
            return ItemHandlerHelper2.insertItem((IItemHandler)controller.inventoryHandler, stack, simulate);
        }
    }
}

