/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.crafting.GenericedRecipeStorage;
import steve_gall.minecolonies_compatibility.api.common.crafting.ISecondaryRollableRecipeStorage;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.crafting.ItemStorageHelper;
import steve_gall.minecolonies_compatibility.core.common.util.NBTUtils2;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingChanceResult;
import steve_gall.minecolonies_compatibility.module.common.farmersdelight.crafting.CuttingGenericRecipe;
import steve_gall.minecolonies_tweaks.core.common.MineColoniesTweaks;

public class CuttingRecipeStorage
extends GenericedRecipeStorage<CuttingGenericRecipe>
implements ISecondaryRollableRecipeStorage {
    public static final ResourceLocation ID = MineColoniesCompatibility.rl("farmerdelight_cutting");
    private final ResourceLocation recipeId;
    private final List<ItemStorage> ingreidnts;
    private final List<CuttingChanceResult> results;
    private final EquipmentTypeEntry toolType;
    private final CuttingGenericRecipe genericRecipe;

    public static void serialize(IFactoryController controller, CompoundTag tag, CuttingRecipeStorage recipe) {
        tag.m_128359_("recipeId", recipe.recipeId.toString());
        NBTUtils2.serializeCollection(tag, "ingreidnts", recipe.ingreidnts, arg_0 -> ((IFactoryController)controller).serialize(arg_0));
        NBTUtils2.serializeCollection(tag, "results", recipe.results, CuttingChanceResult::serialize);
        tag.m_128359_("toolType", recipe.toolType.getRegistryName().toString());
        tag.m_128405_("version", 1);
    }

    public static CuttingRecipeStorage deserialize(IFactoryController controller, CompoundTag tag) {
        ResourceLocation recipeId = new ResourceLocation(tag.m_128461_("recipeId"));
        List<ItemStorage> ingreidnts = NBTUtils2.deserializeList(tag, "ingreidnts", arg_0 -> ((IFactoryController)controller).deserialize(arg_0));
        List<CuttingChanceResult> results = NBTUtils2.deserializeList(tag, "results", CuttingChanceResult::deserialize);
        int version = tag.m_128451_("version");
        EquipmentTypeEntry toolType = version == 0 ? (EquipmentTypeEntry)IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry().getValue(MineColoniesTweaks.rl((String)tag.m_128461_("toolType"))) : (EquipmentTypeEntry)IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry().getValue(new ResourceLocation(tag.m_128461_("toolType")));
        return new CuttingRecipeStorage(recipeId, ingreidnts, results, toolType);
    }

    public CuttingRecipeStorage(ResourceLocation recipeId, List<ItemStorage> ingreidnts, List<CuttingChanceResult> results, EquipmentTypeEntry toolType) {
        this.recipeId = recipeId;
        this.ingreidnts = ItemStorageHelper.filterNotEmpty(ingreidnts);
        this.results = ImmutableList.copyOf(results);
        this.toolType = toolType;
        this.genericRecipe = new CuttingGenericRecipe(recipeId, ItemStorageHelper.getStacksLists(ingreidnts), results, toolType);
    }

    @Override
    @NotNull
    public List<ItemStack> rollSecondaryOutputs(@NotNull LootParams context) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (CuttingChanceResult result : this.genericRecipe.getAdditionalResults()) {
            double roll = context.m_287182_().m_213780_().m_188500_();
            if (!(roll <= (double)result.getChance())) continue;
            list.add(result.getStack());
        }
        return list;
    }

    public int hashCode() {
        return Objects.hash(this.recipeId, this.ingreidnts, this.results, this.toolType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CuttingRecipeStorage) {
            CuttingRecipeStorage other = (CuttingRecipeStorage)o;
            return this.recipeId.equals((Object)other.recipeId) && this.ingreidnts.equals(other.ingreidnts) && this.results.equals(other.results) && this.toolType.equals(other.toolType);
        }
        return false;
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ResourceLocation getRecipeId() {
        return this.recipeId;
    }

    public List<ItemStorage> getInput() {
        return this.ingreidnts;
    }

    public List<CuttingChanceResult> getResults() {
        return this.results;
    }

    @Override
    @NotNull
    public CuttingGenericRecipe getGenericRecipe() {
        return this.genericRecipe;
    }
}

