/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.PistolItem;
import ewewukek.musketmod.Sounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.CustomizedAIContext;
import steve_gall.minecolonies_compatibility.api.common.entity.ai.guard.CustomizedAIGunner;
import steve_gall.minecolonies_compatibility.core.common.MineColoniesCompatibility;
import steve_gall.minecolonies_compatibility.core.common.config.MineColoniesCompatibilityConfigServer;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.AttackDelayConfig;
import steve_gall.minecolonies_compatibility.core.common.entity.ai.guard.BulletMode;
import steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod.Cartridge;
import steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod.DummyGun;
import steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod.ModuleItems;
import steve_gall.minecolonies_compatibility.module.common.ewewukeks_musketmod.ewewukekMusketConfig;
import steve_gall.minecolonies_tweaks.api.common.requestsystem.IDeliverableObject;

public abstract class GunnerGunAI
extends CustomizedAIGunner {
    public static final String TAG_KEY = MineColoniesCompatibility.rl("ewewukeks_musketmod_gun").toString();

    @Override
    protected boolean testAmmo(@NotNull AbstractEntityCitizen user, @NotNull ItemStack stack) {
        return stack.m_41720_() == Items.CARTRIDGE;
    }

    @Override
    @Nullable
    protected IDeliverableObject createAmmoRequest(@NotNull AbstractEntityCitizen user, int minCount) {
        return new Cartridge(minCount);
    }

    @Override
    protected boolean isAmmoRequest(@NotNull AbstractEntityCitizen user, @NotNull IDeliverableObject object) {
        return object instanceof Cartridge;
    }

    @Override
    public boolean reload(@NotNull AbstractEntityCitizen user, boolean forRangedAttack) {
        if (!this.isLoaded(user)) {
            this.startReloadTimer(user);
            return false;
        }
        return true;
    }

    @Override
    protected void onReloadTimerStarted(@NotNull AbstractEntityCitizen user) {
        super.onReloadTimerStarted(user);
        this.setLoadingPhase(user, 0);
    }

    @Override
    protected boolean onReloadTimerRunning(@NotNull AbstractEntityCitizen user) {
        int time = this.getReloadTimerElapsed(user);
        int phase = this.getLoadingPhase(user);
        if (phase == 0 && time >= 5) {
            user.m_5496_(Sounds.MUSKET_LOAD_0, 0.8f, 1.0f);
            this.setLoadingPhase(user, 1);
        } else if (phase == 1 && time >= 10) {
            user.m_5496_(Sounds.MUSKET_LOAD_1, 0.8f, 1.0f);
            this.setLoadingPhase(user, 2);
        } else if (phase == 2 && time >= 20) {
            user.m_5496_(Sounds.MUSKET_LOAD_2, 0.8f, 1.0f);
            this.setLoadingPhase(user, 3);
        } else if (phase == 3 && time >= 30) {
            user.m_5496_(Sounds.MUSKET_READY, 0.8f, 1.0f);
            this.setLoadingPhase(user, 4);
        }
        return super.onReloadTimerRunning(user);
    }

    @Override
    protected void onReloadTimerStopped(@NotNull AbstractEntityCitizen user, boolean complete) {
        super.onReloadTimerStopped(user, complete);
        if (complete) {
            this.setLoaded(user, true);
        }
    }

    @Override
    public void doRangedAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
        ItemStack weapon = this.getMainHandItem(user);
        Item item = weapon.m_41720_();
        if (item instanceof GunItem) {
            GunItem gun = (GunItem)item;
            this.doRangedAttack(user, target, gun, weapon);
        }
    }

    private void doRangedAttack(AbstractEntityCitizen user, LivingEntity target, GunItem original, ItemStack weapon) {
        ewewukekMusketConfig.JobConfig.GunnerGunConfig config = this.getWeaponConfig();
        BulletMode bulletMode = this.getBulletMode();
        IItemHandler inventory = user.getItemHandlerCitizen();
        int bulletSlot = this.getAmmoSlot(user, inventory);
        ItemStack bullet = ItemStack.f_41583_;
        GunItem gun = null;
        if (bulletMode.canUse() && bulletSlot > -1) {
            gun = original;
            bullet = inventory.extractItem(bulletSlot, 1, false);
        } else if (bulletMode.canDefault()) {
            double damage = config.defaultBulletDamage.apply(user, this.getPrimarySkillLevel(user));
            DummyGun dummyGun = (DummyGun)((Object)ModuleItems.DUMMY_GUN.get());
            dummyGun.setParent(original);
            dummyGun.setDamage((float)damage / Config.mobDamageMultiplier);
            gun = dummyGun;
            bullet = ItemStack.f_41583_.m_41777_();
        }
        if (bullet != null) {
            InteractionHand hand = InteractionHand.MAIN_HAND;
            Vec3 direction = gun.aimAt((LivingEntity)user, target);
            gun.fire((LivingEntity)user, weapon, direction, gun.smokeOffsetFor((LivingEntity)user, hand));
            user.m_5496_(gun.fireSound(weapon), 3.5f, 1.0f);
        } else {
            user.m_5496_((SoundEvent)SoundEvents.f_12215_.get(), 1.0f, 1.0f);
        }
        this.setLoaded(user, false);
    }

    @Override
    @Nullable
    protected AttackDelayConfig getAttackDealyConfig() {
        return this.getWeaponConfig().attackDelay;
    }

    @Override
    protected int getReloadTimerDuration() {
        return 40;
    }

    @Override
    @NotNull
    public String getTagKey() {
        return TAG_KEY;
    }

    public abstract ewewukekMusketConfig.JobConfig.GunnerGunConfig getWeaponConfig();

    public boolean isLoaded(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).m_128471_("loaded");
    }

    public void setLoaded(@NotNull AbstractEntityCitizen user, boolean loaded) {
        this.getOrCreateTag(user).m_128379_("loaded", loaded);
    }

    public int getLoadingPhase(@NotNull AbstractEntityCitizen user) {
        return this.getOrEmptyTag(user).m_128451_("loadingPhase");
    }

    public void setLoadingPhase(@NotNull AbstractEntityCitizen user, int phase) {
        this.getOrCreateTag(user).m_128405_("loadingPhase", phase);
    }

    public static class Pistol
    extends GunnerGunAI {
        @Override
        public boolean test(@NotNull CustomizedAIContext context) {
            return super.test(context) && context.getWeapon().m_41720_() instanceof PistolItem;
        }

        @Override
        public boolean canMeleeAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
            return false;
        }

        @Override
        public ewewukekMusketConfig.JobConfig.GunnerGunConfig getWeaponConfig() {
            return MineColoniesCompatibilityConfigServer.INSTANCE.modules.ewewukekMusket.job.gunnerPistol;
        }
    }

    public static class Musket
    extends GunnerGunAI {
        @Override
        public boolean test(@NotNull CustomizedAIContext context) {
            return super.test(context) && context.getWeapon().m_41720_() instanceof MusketItem;
        }

        @Override
        public boolean canMeleeAttack(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
            return this.getMainHandItem(user).m_41720_() == Items.MUSKET_WITH_BAYONET;
        }

        @Override
        public float getMeleeAttackDamage(@NotNull AbstractEntityCitizen user, @NotNull LivingEntity target) {
            float damage = super.getMeleeAttackDamage(user, target);
            return damage += (float)(Config.bayonetDamage - 1);
        }

        @Override
        public ewewukekMusketConfig.JobConfig.GunnerGunConfig getWeaponConfig() {
            return MineColoniesCompatibilityConfigServer.INSTANCE.modules.ewewukekMusket.job.gunnerMusket;
        }
    }
}

