/*
 * Decompiled with CFR 0.152.
 */
package steve_gall.minecolonies_compatibility.module.common.collectorsreap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.brdle.collectorsreap.common.block.FruitBushBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import steve_gall.minecolonies_compatibility.api.common.plant.CustomizedFruit;
import steve_gall.minecolonies_compatibility.api.common.plant.HarvesterContext;
import steve_gall.minecolonies_compatibility.api.common.plant.PlantBlockContext;

public class FruitBushFruit
extends CustomizedFruit {
    private final FruitBushBlock block;
    private final List<ItemStack> blockIcons;
    private final List<ItemStack> itemIcons;

    public FruitBushFruit(FruitBushBlock block) {
        this.block = block;
        this.blockIcons = Arrays.asList(new ItemStack((ItemLike)block.getSeeds()));
        ArrayList<ItemStack> itemIcons = new ArrayList<ItemStack>();
        itemIcons.add(new ItemStack((ItemLike)block.getFruit()));
        ItemStack special = block.getSpecialFruit();
        if (!special.m_41619_()) {
            itemIcons.add(special.m_41777_());
        }
        this.itemIcons = itemIcons;
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ForgeRegistries.BLOCKS.getKey((Object)this.block);
    }

    @Override
    @NotNull
    public List<ItemStack> getBlockIcons() {
        return this.blockIcons;
    }

    @Override
    @NotNull
    public List<ItemStack> getItemIcons() {
        return this.itemIcons;
    }

    @Override
    public boolean test(@NotNull PlantBlockContext context) {
        return context.getState().m_60734_() == this.block;
    }

    @Override
    public boolean canHarvest(@NotNull PlantBlockContext context) {
        return (Integer)context.getState().m_61143_((Property)FruitBushBlock.AGE) == 4;
    }

    @Override
    public boolean isMaxHarvest(@NotNull PlantBlockContext context) {
        return true;
    }

    @Override
    @NotNull
    public List<ItemStack> harvest(@NotNull PlantBlockContext context, @NotNull HarvesterContext harvester) {
        LevelReader levelReader = context.getLevel();
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            BlockState state = context.getState();
            BlockPos lowerPos = null;
            BlockState lowerState = null;
            if (state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                lowerPos = context.getPosition().m_7495_();
                lowerState = level.m_8055_(lowerPos);
            } else {
                lowerPos = context.getPosition();
                lowerState = state;
            }
            List<ItemStack> drops = this.getDrops(level, lowerPos);
            BlockState newLowerState = (BlockState)lowerState.m_61124_((Property)FruitBushBlock.AGE, (Comparable)Integer.valueOf(2));
            level.m_7731_(lowerPos, newLowerState, 2);
            level.m_7731_(lowerPos.m_7494_(), (BlockState)newLowerState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
            return drops;
        }
        return Collections.emptyList();
    }

    private List<ItemStack> getDrops(Level level, BlockPos pos) {
        ItemStack stack;
        if (this.block.isSpecial(level, pos)) {
            stack = this.block.getSpecialFruit().m_41777_();
        } else {
            int additional = level.m_213780_().m_216332_(1, 2);
            stack = new ItemStack((ItemLike)this.block.getFruit(), this.block.getNumFruit(additional));
        }
        return Arrays.asList(stack);
    }
}

